from typing import NamedTuple, Pattern, TypedDict


class URLPath(NamedTuple):
    group: int
    pattern: Pattern


class URLMime(NamedTuple):
    pattern: Pattern
    mime: str


class UrlDetails(TypedDict):
    default_mimetype: str
    domain_name: str
    extension: str
    hostname: str
    params: dict
    search_term: str
    title: str
