from ..settings import re_icompile
from ..typehints import URLMime


PATH_MIMES = (
    # API
    URLMime(re_icompile(r'[\b/]apis?|safebrowsing[\b/]'), 'application/api'),
    URLMime(re_icompile(r'apple-app-site-association'), 'application/api'),

    # Assign html cruft to "api" to reduce visibility
    URLMime(re_icompile(r'/(pagead|gampad|postAdLog)/'), 'application/api'),

    # Images
    URLMime(re_icompile(r'/(image|img|photo|thumbs?|avatar)s?/'), 'image/jpg'),
    URLMime(re_icompile(r'thumb(nail|asset)'), 'image/jpg'),
    URLMime(re_icompile(r'captcha|emoticon|/icons?/'), 'image/png'),
    URLMime(re_icompile(r'icon'), 'image/png'),

    # Javascript
    URLMime(re_icompile(r'/(js|javascript)/'), 'application/javascript'),
    URLMime(re_icompile(r'/(widgets|scripts?|servlet)/'), 'application/javascript'),

    # Json
    URLMime(re_icompile(r'[\b/]ajax[\b/]|viewpoll'), 'application/json'),

    # XML
    URLMime(re_icompile(r'[\b/]tiles[\b/]'), 'text/xml'),
    URLMime(re_icompile(r'(metadata|rss|app|single|multiple|live)-?tile'), 'text/xml'),
)

HOSTNAME_MIMES = (

    # API
    URLMime(re_icompile(r'^(apis?|ajax)\.'), 'application/api'),
    URLMime(re_icompile(r'service-updates\.adobe\.com'), 'application/api'),
    URLMime(re_icompile(r'apps\.microsoft\.com'), 'application/api'),
    URLMime(re_icompile(r'dellupdater\.dell\.com'), 'application/api'),
    URLMime(re_icompile(r'seal\.websecurity\.norton\.com'), 'application/api'),
    URLMime(re_icompile(r'client\.akamai\.com'), 'application/api'),
    URLMime(re_icompile(r'(self-repair|versioncheck\.addons|sync\.services)\.mozilla\.'), 'application/api'),
    URLMime(re_icompile(r'(heartbeat|pipe|login|asm|kes|registrar)\.skype\.com'), 'application/api'),
    URLMime(re_icompile(r'^ping|api|ypi|oath\.'), 'application/api'),
    URLMime(re_icompile(r'hotmail\.com'), 'application/api'),
    URLMime(re_icompile(r'(notify\d|debug|d|client|client-cf)\.dropbox\.com'), 'application/api'),
    URLMime(re_icompile(r'(docs|drive|accounts|apis|checkout|safebrowsing-cache|toolbarqueries)\.google\.'), 'application/api'),
    URLMime(re_icompile(r'google\.com/webchat'), 'application/api'),
    URLMime(re_icompile(r'googleapis\.'), 'application/api'),
    URLMime(re_icompile(r'accounts.youtube\.com'), 'application/api'),
    URLMime(re_icompile(r'(tcontent|qb\d\d(bgpatch|bgocd)|qbbgpatchsp)\.quickbooks'), 'application/api'),
    URLMime(re_icompile(r'(sci|qbdt|qbdataprotect|datasync)\.intuit\.com'), 'application/api'),
    URLMime(re_icompile(r'(calendar|people|login|directory|officeapps|mail|messenger)\.live\.com'), 'application/api'),

    # Images
    URLMime(re_icompile(r'cdn\.skype\.com'), 'image/jpg'),

    # Javascript
    URLMime(re_icompile(r'(api|staticxx?|graph)\.facebook.com'), 'application/javascript'),
    URLMime(re_icompile(r'twitter\.com/widgets'), 'application/javascript'),
    URLMime(re_icompile(r'(analytics|syndication)\.twitter\.com'), 'application/javascript'),

    # XML
    URLMime(re_icompile(r'clients?\d?\.google\.'), 'text/xml'),
)


URL_MIMES = (

    #API
    URLMime(re_icompile(r'Microsoft-Server-ActiveSync'), 'application/api'),

    # Javascript
    URLMime(re_icompile(r'facebook\.com/(plugins|impression|email_open|offsite_event|tr|fr)'), 'application/javascript'),

    # XML
    URLMime(re_icompile(r'bing\.com/as/suggestions'), 'text/xml'),

    # Images
    URLMime(re_icompile(r'gstatic\.com/images'), 'image/jpg'),

    # Video
    URLMime(re_icompile(r'youtube\.com/embed'), 'video/flv'),

)


__all__ = (
    'PATH_MIMES',
    'HOSTNAME_MIMES',
    'URL_MIMES',
)
