ASSET_TYPES = {
    'font',
}
ASSET_SUBTYPES = {
    'atom',
    'css',
    'google-earth.kml',
    'google-earth.kmz',
    'hessian',
    'javascript',
    'font',
    'gml',
    'json',
    'hal',
    'mapbox-vector-tile',
    'opensearchdescription',
    'protobuf',
    'postscript',
    'relang-compact-syntax',
    'rss',
    'thrift',
    'troff',
    'truetype',
    'vrml',
    'woff',
    'wbxml',
    'xml',
}

API_TYPES = {
    'message',
}

API_SUBTYPES = {
    'abba-feature-flags',
    'apple-aspen-mdm',
    'dvb.service',
    'mercury-mget-reply',
    'api',
    'dns',
    'dns-message',
    'checksum',
    'plist',
    'activemessage',
    'edi-consent',
    'edi-x12',
    'edifact',
    'remote-printing',
    'safebrowsing',
    'soap',
    'qfn-encoded',
    'www-form-urlencoded',
    'rba.search.v1',
    'rba.calendar.v1',
    'smil',
    'sync',
}

AUDIO_VIDEO_TYPES = {
    'audio',
    'conference',
    'music',
    'video',
    'xgl',
}

AUDIO_VIDEO_SUBTYPES = {
    'amazonui-streaming',
    'conference',
    'mpegurl',
    'shockwave',
    'shockwave-flash',
    'flash',
    'mpeg',
    'quicktime',
    'ringing-tones',
    'yt-ump',
}

DOCUMENT_SUBTYPES = {
    'database',
    'document',
    'rtf',
    'richtext',
    'freehand',
    'onenote',
    'pagemaker',
    'excel',
    'mathematica',
    'powerpoint',
    'word',
    'wordperfect',
    'works',
    'write',
    'writer',
    'chart',
    'calc',
    'draw',
    'impress',
    'math',
    'kword',
    'kspread',
    'kpresenter',
    'kchart',
    'latex',
    'lotus-organizer',
    'presentation',
    'spreadsheet',
    'opendocument.text',
    'opendocument.graphics',
    'opendocument.presentation',
    'opendocument.spreadsheet',
    'opendocument.chart',
    'opendocument.formula',
    'opendocument.database',
    'opendocument.image',
}

BOOK_SUBTYPES = {
    'book',
    'ebook',
    'epub',
    'pdf',
}

PROGRAMS_SUBTYPES = {
    'android.package-delta',
    'android.package-archive',
    'bzip',
    'bzip2',
    'compress',
    'compressed',
    'chrome-extension',
    'deb',
    'exe',
    'lzma',
    'lzx',
    'rar-compressed',
    'cab-compressed',
    'rpm',
    'rar',
    'tar',
    'gzip',
    'gunzip',
    'gtar',
    'zip',
    'msdownload',
    'msi',
    'msdos-program',
    'microsoftpatch',
    'iso',
    'iso9660-image',
    'newton-compatible-pkg',
    'sqlite3',
    'stuffit',
    'wasm',
}

PAGE_VISUALS_TYPES = {
    'image',
    'chemical',
    'model',
    'world',
}

FILES_SUBTYPES = {
    'apple.pkpass',
    'apple-diskimage',
    'ibm.secure-container',
    'autoconfig',
    'byteranges',
    'binary',
    'der',
    'fastinfoset',
    '509-ca-cert',
    '509-user-cert',
    'ocsp-response',
    'octet',
    'pgp',
    'pgp-keys',
    'pgp-signature',
    'pgp-encrypted',
    'pkicrl',
    'pkicert',
    'pkix-cert',
    'pkix-crl',
    'pkcs-crl',
    'pkcs-cert',
    'pkcs7-certificates',
    'pkcs7-signature',
    'pkcs7-certreqresp',
    'pkcs7-crl',
    'pkcs7-mime',
    'pkcs10',
    'pkcs12',
    'pki.seccat',
    'pki.pko',

    # programming
    'bytecode',
    'bsh',
    'c',
    'csh',
    'ksh',
    'zsh',
    'lisp',
    'elisp',
    'java',
    'guile',
    'scheme',
    'script',
    'sh',
    'tcl',
    'tcsh',
    'tex',
    'texinfo',
    'pascal',
    'python',
    'perl',
    'rexx',
}

# must be checked last, after specific matches
FILES_TYPES = {
    'content',
    'file',
    'force-download',
    'multipart',
    'text',
    'undefined',
    'unknown',
}

FILE_SUBTYPE_STRINGS = ('')

# Map malformed mimetypes to a desired equivalent
MIMETYPE_MAP = {
    'application': 'application/unknown',
    'frameprotocol/framejson': 'application/json',
    'unknown': 'unknown/unknown',
    'guess': 'unknown/unknown',
    'none': 'unknown/unknown',
    'null': 'unknown/unknown',
    'other': 'unknown/unknown',
    'bmp': 'image/bmp',
    'application/html': 'text/html',
    'document': 'text/html',
    'html': 'text/html',
    'xml': 'application/xml',
    '*/*': 'text/html',
    'smartfinddata': 'application/json',
    '$picmime': 'image/jpg',
    'binary': 'application/binary',
    'image/': 'image/jpg',
    'image': 'image/jpg',
    'application/jpg': 'image/jpg',
    'application/gif': 'image/gif',
    'application/png': 'image/png',
    'jpg': 'image/jpg',
    'jpeg': 'image/jpg',
    'js': 'application/javascript',
    'type/js': 'application/javascript',
    'ecmascript': 'application/javascript',
    'javascript': 'application/javascript',
    'captcha.jpg': 'image/jpg',
    'captcha.jpeg': 'image/jpg',
    'gif': 'image/gif',
    'tif': 'image/tiff',
    'tiff': 'image/tiff',
    'pdf': 'application/pdf',
    'png': 'image/png',
    'mp4': 'video/mp4',
    'video': 'video/mp4',
    'woff': 'application/woff',
    'ttf': 'application/font',
    'otf': 'application/font',
    'utf-8': 'text/plain',
    'utf8': 'text/plain',
    'text': 'text/plain',
    'application/text': 'text/plain',
    'plain/text': 'text/plain',
    'text/text': 'text/plain',
    'text/proto': 'application/protobuf',
    'text/javascript': 'application/javascript',
    'text/x-javascript': 'application/javascript',
}

# standardize these subtype variations
# tree prefixes are removed, so don't add
# x-<subtype>, vnd.<subtype> entries
SUBTYPE_MAP = {
    'api+v1': 'api',
    'api+v2': 'api',
    'api+v3': 'api',
    'api.v1': 'api',
    'api.v2': 'api',
    'api.v3': 'api',
    'api-v1': 'api',
    'api-v2': 'api',
    'api-v3': 'api',
    'api-problem': 'api',
    'apple-plist': 'plist',
    'apple.mpegurl': 'mpegurl',
    'dns-json': 'dns',
    'dns+json': 'dns',
    'dns-udpwireformat': 'dns',
    'java-archive': 'java',
    'java-byte-code': 'java',
    'java-bytecode': 'java',
    'java-class': 'java',
    'java-jnlp-file': 'java',
    'bytecodes': 'bytecode',
    'perl-module': 'perl',
    'debian-package': 'deb',
    'json-amazonui-streaming': 'json',
    'ecmascript': 'javascript',
    'woff2': 'woff',
    'font-type1': 'font',
    'font-woff': 'font',
    'fontwoff': 'font',
    'font-woff2': 'font',
    'fontwoff2': 'font',
    'fontobject': 'font',
    'font-object': 'font',
    'font-sfnt': 'font',
    'font-opentype': 'font',
    'font-truetype': 'font',
    'google.safebrowsing-chunk': 'safebrowsing',
    'safebrowsing-chunk': 'safebrowsing',
    'jpeg': 'jpg',
    'jpe': 'jpg',
    'pjpeg': 'jpg',
    'jsonp': 'json',
    'hal+json': 'json',
    'amz-json-1.0': 'json',
    'amz-json-1.1': 'json',
    'amz-json-1.2': 'json',
    'kfx-ebook': 'ebook',
    'htm': 'html',
    'webviewhtml': 'html',
    'xht': 'html',
    'xhtml': 'html',
    'xhtml+xml': 'html',
    'html+xml': 'html',
    'pskc+xml': 'html',
    'rn-realtext': 'richtext',
    'msonenote': 'onenote',
    'ms-onenote': 'onenote',
    'msaccess': 'access',
    'ms-access': 'access',
    'ms-excel': 'spreadsheet',
    'msexcel': 'spreadsheet',
    'ms-font': 'font',
    'msfontobject': 'fontobject',
    'ms-fontobject': 'fontobject',
    'msfont': 'font',
    'mspowerpoint': 'powerpoint',
    'ms-powerpoint': 'powerpoint',
    'ms-project': 'project',
    'msword': 'word',
    'ms-word': 'word',
    'mswrite': 'word',
    'ms-write': 'word',
    'ms-works': 'works',
    'msworks': 'works',
    'mswpl': 'wpl',
    'ms-wpl': 'wpl',
    'ns-proxy-autoconfig': 'autoconfig',
    'nokia.ringing-tone': 'ringing-tones',
    'nokia.ringing-tones': 'ringing-tones',
    'octet-stream-compressible': 'octet',
    'octet-stream': 'octet',
    'octetstream': 'octet',
    'json+v1': 'json',
    'json+v2': 'json',
    'json+v3': 'json',
    'json.v1': 'json',
    'json.v2': 'json',
    'json.v3': 'json',
    'google.octet-stream-compressible': 'octet',
    'json+protobuf': 'protobuf',
    'protobuffer': 'protobuf',
    'protobuf-gz': 'protobuf',
    'com.apple.me.mmcs+protobuf': 'protobuf',
    'redhat-package-manager': 'rpm',
    'starwriter': 'writer',
    'starcalc': 'spreadsheet',
    'stardraw': 'draw',
    'starimpress': 'presentation',
    'starmath': 'spreadsheet',
    'starchart': 'chart',
    'draw.template': 'draw',
    'calc.template': 'spreadsheet',
    'calc-template': 'spreadsheet',
    'impress.template': 'presentation',
    'impress-template': 'presentation',
    'impress.packed': 'presentation',
    'impress-packed': 'presentation',
    'writer.global': 'writer',
    'writer-global': 'writer',
    'writer.template': 'writer',
    'writer-template': 'writer',
    'wordprocessingml.document': 'document',
    'wordprocessingml.template': 'document',
    'spreadsheetml.sheet': 'spreadsheet',
    'spreadsheetml.template': 'spreadsheet',
    'stuffitx': 'stuffit',
    'presentationml.presentation': 'presentation',
    'presentationml.template': 'presentation',
    'opendocument.graphics-template': 'opendocument.graphics',
    'opendocument.presentation-template': 'opendocument.presentation',
    'opendocument.spreadsheet-template': 'opendocument.spreadsheet',
    'opendocument.formula-template': 'opendocument.spreadsheet',
    'opendocument.text-template': 'opendocument.text',
    'opendocument.text-web': 'opendocument.text',
    'opendocument.text-master': 'opendocument.text',
    'quark.quarkxpress': 'quark',
    'quark.quarkexpress': 'quark',
    'quark-quarkxpress': 'quark',
    'quark-quarkexpress': 'quark',
    'wordperfect5.1': 'wordperfect',
    'wordperfect6.0': 'wordperfect',
    'x509-ca-cert': '509-ca-cert',
    'x509-ca-ra-cert': '509-ca-cert',
    'x509-user-cert': '509-user-cert',
    'unknown-content-type': 'unknown',
    'xml+sfml': 'xml',
    'xslt': 'xml',
    'sync.wbxml': 'sync',
    'ace-compressed': 'zip',
    '7z-compressed': 'zip',
    'zip-compressed': 'zip',
}

SUBTYPE_TREE_PREFIXES = (
    'prs.',
    'vnd.adobe.',
    'vnd.clonk.',
    'vnd.cluetrust.',
    'vnd.google.',
    'vnd.novadigm.',
    'vnd.nuera.',
    'vnd.crick.',
    'vnd.ms-',
    'vnd.sun.xml.',
    'vnd.sun.',
    'vnd.stardivision.',
    'vnd.oasis.',
    'vnd.openofficeorg.',
    'vnd.openxmlformats-officedocument.',
    'vnd.wap.',
    'vnd.',
    'script.',
    'x-script.',
    'x-bytecode.',
    'x-',
    'x.',
)

STRUCTURED_SUFFIXES = (
    'ber',
    'der',
    'fastinfoset',
    'gzip',
    'json',
    'ttf',
    'otf',
    'oembed',
    'wbxml',
    'xml',
    'zip',
    'x',
)

MAIN_TYPES = {
    'application',
    'audio',
    'chemical',
    'conference',
    'content',
    'file',
    'font',
    'force-download',
    'image',
    'message',
    'multipart',
    'music',
    'text',
    'video',
    'world',
    'undefined',
    'unknown',
}
