EXTENSION_MIMETYPE_MAP = {
    "avatar": "image/png",
    "preview": "image/png",
    "123": "application/lotus-1-2-3",
    "3dm": "world/3dmf",
    "3dmf": "world/3dmf",
    "3dml": "text/in3d.3dml",
    "3ds": "image/3ds",
    "3g2": "video/3gpp2",
    "3gp": "video/3gpp",
    "7z": "application/7z-compressed",
    "a": "application/octet-stream",
    "aab": "application/authorware-bin",
    "aac": "audio/aac",
    "aam": "application/authorware-map",
    "aas": "application/authorware-seg",
    "abc": "text/plain",
    "abw": "application/abiword",
    "ac": "application/pkiattr-cert",
    "acc": "application/americandynamics.acc",
    "ace": "application/ace-compressed",
    "acgi": "text/html",
    "acu": "application/acucobol",
    "acutc": "application/acucorp",
    "adf": "application/zip",
    "adp": "audio/adpcm",
    "aep": "application/audiograph",
    "afl": "video/animaflex",
    "afm": "application/font",
    "afp": "application/ibm.modcap",
    "ahead": "application/ahead.space",
    "ai": "application/postscript",
    "aif": "audio/aiff",
    "aifc": "audio/aiff",
    "aiff": "audio/aiff",
    "aim": "application/aim",
    "aip": "text/plain",
    "air": "application/adobe.air-application-installer-package",
    "ait": "application/dvb.ait",
    "alc": "chemical/alchemy",
    "ami": "application/amiga.ami",
    "ani": "application/navi-animation",
    "aos": "application/nokia-9000-communicator-add-on-software",
    "apk": "application/android.package-archive",
    "appcache": "text/cache-manifest",
    "application": "application/application",
    "apr": "application/lotus-approach",
    "aps": "application/mime",
    "arc": "application/freearc",
    "arj": "application/arj",
    "art": "image/jg",
    "asc": "application/pgp-signature",
    "asf": "video/asf",
    "asm": "text/asm",
    "asmx": "text/html",
    "asn": "chemical/ncbi-asn1",
    "aso": "application/accpac.simply.aso",
    "asp": "text/html",
    "aspx": "text/html",
    "asx": "video/asf",
    "atc": "application/acucorp",
    "atom": "application/atom",
    "atomcat": "application/atomcat",
    "atomsvc": "application/atomsvc",
    "atx": "application/antix.game-component",
    "au": "audio/basic",
    "avi": "video/msvideo",
    "avs": "video/avs-video",
    "aw": "application/applixware",
    "axd": "text/config",
    "azf": "application/airzip.filesecure.azf",
    "azs": "application/airzip.filesecure.azs",
    "azw": "application/amazon.ebook",
    "b": "chemical/molconn-Z",
    "bat": "application/msdownload",
    "bcpio": "application/bcpio",
    "bdf": "application/font-bdf",
    "bdm": "application/syncml.dm+wbxml",
    "bed": "application/realvnc.bed",
    "bh2": "application/fujitsu.oasysprs",
    "bin": "application/binary",
    "blb": "application/blorb",
    "blorb": "application/blorb",
    "bm": "image/bmp",
    "bmi": "application/bmi",
    "bmp": "image/bmp",
    "boo": "application/book",
    "book": "application/framemaker",
    "bootstrap": "video/abst",
    "box": "application/previewsystems.box",
    "boz": "application/bzip2",
    "bpk": "application/octet-stream",
    "bsd": "chemical/crossfire",
    "bsh": "application/bsh",
    "btif": "image/prs.btif",
    "bz": "application/bzip",
    "bz2": "application/bzip2",
    "c": "text/c",
    "c++": "text/c",
    "c11amc": "application/cartomobile-config",
    "c11amz": "application/cartomobile-config-pkg",
    "c3d": "chemical/chem3d",
    "c4d": "application/c4group",
    "c4f": "application/c4group",
    "c4g": "application/c4group",
    "c4p": "application/c4group",
    "c4u": "application/c4group",
    "cab": "application/cab-compressed",
    "caf": "audio/caf",
    "cap": "application/tcpdump.pcap",
    "car": "application/curl.car",
    "cascii": "chemical/cactvs-binary",
    "cat": "application/pki.seccat",
    "cb7": "application/cbr",
    "cba": "application/cbr",
    "cbin": "chemical/cactvs-binary",
    "cbr": "application/cbr",
    "cbt": "application/cbr",
    "cbz": "application/cbr",
    "cc": "text/c",
    "ccad": "application/clariscad",
    "cco": "application/cocoa",
    "cct": "application/director",
    "ccxml": "application/ccxml",
    "cdbcmsg": "application/contact.cmsg",
    "cdiff": "application/binary",
    "cdf": "application/netcdf",
    "cdkey": "application/mediastation.cdkey",
    "cdmia": "application/cdmi-capability",
    "cdmic": "application/cdmi-container",
    "cdmid": "application/cdmi-domain",
    "cdmio": "application/cdmi-object",
    "cdmiq": "application/cdmi-queue",
    "cdx": "chemical/cdx",
    "cdxml": "application/chemdraw",
    "cdy": "application/cinderella",
    "cer": "application/pkicert",
    "cfs": "application/cfs-compressed",
    "cgm": "image/cgm",
    "cha": "application/chat",
    "chat": "application/chat",
    "chk": "text/plain",
    "chm": "chemical/chemdraw",
    "chrt": "application/kde.kchart",
    "cif": "chemical/cif",
    "cii": "application/anser-web-certificate-issue-initiation",
    "cil": "application/artgalry",
    "cla": "application/claymore",
    "class": "application/java-vm",
    "clkk": "application/clicker.keyboard",
    "clkp": "application/clicker.palette",
    "clkt": "application/clicker.template",
    "clkw": "application/clicker.wordbank",
    "clkx": "application/clicker",
    "clp": "application/msclip",
    "cmc": "application/cosmocaller",
    "cmdf": "chemical/cmdf",
    "cml": "chemical/cml",
    "cmp": "application/yellowriver-custom-menu",
    "cmx": "image/cmx",
    "cod": "application/rim.cod",
    "com": "application/msdownload",
    "conf": "text/plain",
    "cpa": "chemical/compass",
    "cpio": "application/cpio",
    "cpp": "text/c",
    "cpt": "application/mac-compactpro",
    "crd": "application/mscardfile",
    "crl": "application/pkicrl",
    "crt": "application/x509-ca-cert",
    "crx": "application/chrome-extension",
    "cryptonote": "application/rig.cryptonote",
    "csf": "chemical/cache-csf",
    "csh": "application/csh",
    "csm": "chemical/csml",
    "csml": "chemical/csml",
    "csp": "application/commonspace",
    "css": "text/css",
    "cst": "application/director",
    "csv": "text/csv",
    "ctab": "chemical/cactvs-binary",
    "ctf": "application/updates",
    "ctx": "chemical/ctx",
    "cu": "application/cu-seeme",
    "cub": "chemical/gaussian-cube",
    "cur": "image/win-bitmap",
    "curl": "text/curl",
    "cww": "application/prs.cww",
    "cxf": "chemical/cxf",
    "cxt": "application/director",
    "cxx": "text/c",
    "dae": "model/collada",
    "daf": "application/mobius.daf",
    "dar": "application/dar",
    "dart": "application/dart",
    "dat": "application/octet-stream",
    "dataless": "application/fdsn.seed",
    "davmount": "application/davmount",
    "dbk": "application/docbook",
    "dcr": "application/director",
    "dcurl": "text/curl.dcurl",
    "dd2": "application/oma.dd2",
    "ddd": "application/fujixerox.ddd",
    "deb": "application/debian-package",
    "deepv": "application/deepv",
    "def": "text/plain",
    "deploy": "text/config",
    "der": "application/x509-ca-cert",
    "dfac": "application/dreamfactory",
    "dgc": "application/dgc-compressed",
    "dic": "text/c",
    "dif": "video/dv",
    "diff": "text/diff",
    "dir": "application/director",
    "dis": "application/mobius.dis",
    "dist": "text/config",
    "distz": "text/config",
    "djv": "image/djvu",
    "djvu": "image/djvu",
    "dl": "video/dl",
    "dll": "application/msdownload",
    "dmg": "application/apple-diskimage",
    "dmp": "application/tcpdump.pcap",
    "dms": "application/zip",
    "dna": "application/dna",
    "do": "text/html",
    "doc": "application/word",
    "docm": "application/word",
    "docx": "application/word",
    "dot": "application/word",
    "dotm": "application/word",
    "dp": "application/osgi.dp",
    "dpg": "application/dpgraph",
    "dpkg": "application/debian-package",
    "dra": "audio/dra",
    "drw": "application/drafting",
    "ds": "chemical/datasheet",
    "dsc": "text/prs.lines.tag",
    "dssc": "application/dssc+der",
    "dtb": "application/dtbook",
    "dtd": "application/xml-dtd",
    "dts": "audio/dts",
    "dtshd": "audio/dts.hd",
    "dump": "text/config",
    "dv": "video/dv",
    "dvb": "video/dvb.file",
    "dvi": "application/dvi",
    "dwf": "model/dwf",
    "dwg": "image/dwg",
    "dx": "chemical/jcamp-dx",
    "dxf": "image/dxf",
    "dxp": "application/spotfire.dxp",
    "dxr": "application/director",
    "ear": "application/java-archive",
    "ecelp4800": "audio/nuera.ecelp4800",
    "ecelp7470": "audio/ecelp7470",
    "ecelp9600": "audio/ecelp9600",
    "ecma": "application/ecmascript",
    "edm": "application/edm",
    "edx": "application/edx",
    "efif": "application/picsel",
    "egg": "application/python-archive",
    "ei6": "application/pg.osasli",
    "el": "text/plain",
    "elc": "application/binary",
    "emb": "chemical/embl-dl-nucleotide",
    "embl": "chemical/embl-dl-nucleotide",
    "emf": "application/msmetafile",
    "eml": "message/rfc822",
    "emma": "application/emma",
    "emz": "application/msmetafile",
    "enc": "application/encrypted-file",
    "env": "application/envoy",
    "eol": "audio/digital-winds",
    "eot": "application/fontobject",
    "eps": "application/postscript",
    "epub": "application/epub",
    "es": "application/esrehber",
    "es3": "application/eszigno3",
    "esa": "application/osgi.subsystem",
    "esf": "application/epson.esf",
    "et3": "application/eszigno3",
    "etx": "text/setext",
    "eva": "application/eva",
    "evy": "application/envoy",
    "exe": "application/msdownload",
    "exi": "application/exi",
    "ext": "application/ext",
    "ez": "application/andrew-inset",
    "ez2": "application/ezpialbum",
    "ez3": "application/ezpipackage",
    "f": "text/fortran",
    "f4f": "video/f4f",
    "f4m": "video/f4m",
    "f4v": "video/f4v",
    "f4x": "video/f4x",
    "f77": "text/fortran",
    "f90": "text/fortran",
    "fbs": "image/fastbidsheet",
    "fcdt": "application/adobe.formscentral.fcdt",
    "fch": "chemical/gaussian-checkpoint",
    "fchk": "chemical/gaussian-checkpoint",
    "fcs": "application/isac.fcs",
    "fdf": "application/fdf",
    "fe_launch": "application/denovo.fcselayout-link",
    "fg5": "application/fujitsu.oasysgp",
    "fgd": "application/director",
    "fh": "image/freehand",
    "fh4": "image/freehand",
    "fh5": "image/freehand",
    "fh7": "image/freehand",
    "fhc": "image/freehand",
    "fif": "image/fif",
    "fig": "application/xfig",
    "flac": "audio/flac",
    "fli": "video/fli",
    "flo": "application/micrografx.flo",
    "flv": "video/flv",
    "flw": "application/kde.kivio",
    "flx": "text/fmi.flexstor",
    "fly": "text/fly",
    "fm": "application/framemaker",
    "fmf": "video/atomic3d-feature",
    "fnc": "application/frogans.fnc",
    "for": "text/fortran",
    "fpx": "image/fpx",
    "frame": "application/framemaker",
    "frl": "application/freeloader",
    "fsc": "application/fsc.weblaunch",
    "fst": "image/fst",
    "ftc": "application/fluxtime.clip",
    "fti": "application/anser-web-funds-transfer-initiation",
    "funk": "audio/make",
    "fvt": "video/fvt",
    "fxp": "application/adobe.fxp",
    "fxpl": "application/adobe.fxp",
    "fzs": "application/fuzzysheet",
    "g": "text/plain",
    "g2w": "application/geoplan",
    "g3": "image/g3fax",
    "g3w": "application/geospace",
    "gac": "application/groove-account",
    "gam": "chemical/gamess-input",
    "gau": "chemical/gaussian-input",
    "gbr": "application/rpki-ghostbusters",
    "gca": "application/gca-compressed",
    "gcg": "chemical/gcg8-sequence",
    "gdl": "model/gdl",
    "gen": "chemical/genbank",
    "geo": "application/dynageo",
    "gex": "application/geometry-explorer",
    "ggb": "application/geogebra.file",
    "ggt": "application/geogebra.tool",
    "ghf": "application/groove-help",
    "gif": "image/gif",
    "gim": "application/groove-identity-message",
    "gl": "video/gl",
    "glh": "application/octet-stream",
    "gml": "application/gml",
    "gmx": "application/gmx",
    "gnumeric": "application/gnumeric",
    "gpg": "application/pgp-encrypted",
    "gph": "application/flographit",
    "gpt": "chemical/mopac-graph",
    "gpx": "application/gpx",
    "gqf": "application/grafeq",
    "gqs": "application/grafeq",
    "gram": "application/srgs",
    "gramps": "application/gramps-xml",
    "gre": "application/geometry-explorer",
    "grv": "application/groove-injector",
    "grxml": "application/srgs",
    "gsd": "audio/gsm",
    "gsf": "application/font-ghostscript",
    "gsm": "audio/gsm",
    "gsp": "application/gsp",
    "gss": "application/gss",
    "gtar": "application/gtar",
    "gtm": "application/groove-tool-message",
    "gtw": "model/gtw",
    "gv": "text/graphviz",
    "gxf": "application/gxf",
    "gxt": "application/geonext",
    "gz": "application/compressed",
    "gzip": "application/gzip",
    "h": "text/c",
    "h261": "video/h261",
    "h263": "video/h263",
    "h264": "video/h264",
    "hal": "application/hal",
    "hbci": "application/hbci",
    "hbs": "text/handlebars-template",
    "hdf": "application/hdf",
    "help": "application/helpfile",
    "hgl": "application/vndhp-hpgl",
    "hh": "text/c",
    "hlb": "text/plain",
    "hlp": "application/winhlp",
    "hpg": "application/hp-hpgl",
    "hpgl": "application/hp-hpgl",
    "hpid": "application/hp-hpid",
    "hps": "application/hp-hps",
    "hqx": "application/mac-binhex40",
    "hta": "application/hta",
    "htc": "text/html",
    "htke": "application/kenameaapp",
    "htm": "text/html",
    "html": "text/html",
    "htmls": "text/html",
    "htt": "text/plain",
    "htx": "text/html",
    "hvd": "application/yamaha.hv-dic",
    "hvp": "application/yamaha.hv-voice",
    "hvs": "application/yamaha.hv-script",
    "i2g": "application/intergeo",
    "icc": "application/iccprofile",
    "ice": "conference/cooltalk",
    "icm": "application/iccprofile",
    "ico": "image/icon",
    "ics": "text/calendar",
    "idc": "text/plain",
    "ief": "image/ief",
    "iefs": "image/ief",
    "ifb": "text/calendar",
    "ifm": "application/shana.informed.formdata",
    "iges": "model/iges",
    "igl": "application/igloader",
    "igm": "application/insors.igm",
    "igs": "model/iges",
    "igx": "application/micrografx.igx",
    "iif": "application/shana.informed.interchange",
    "ima": "application/ima",
    "imap": "application/httpd-imap",
    "imp": "application/accpac.simply.imp",
    "ims": "application/ims",
    "in": "text/plain",
    "inchi": "chemical/inchi",
    "inf": "application/inf",
    "ini": "text/plain",
    "ink": "application/inkml",
    "inkml": "application/inkml",
    "inp": "chemical/gamess-input",
    "ins": "application/internett-signup",
    "install": "application/install-instructions",
    "iota": "application/astraea-software.iota",
    "ip": "application/ip2",
    "ipa": "application/zip",
    "ipfix": "application/ipfix",
    "ipk": "application/shana.informed.package",
    "irm": "application/ibm.rights-management",
    "irp": "application/irepository.package",
    "iso": "application/iso9660-image",
    "ist": "chemical/isostar",
    "istr": "chemical/isostar",
    "isu": "video/isvideo",
    "it": "audio/it",
    "itp": "application/shana.informed.formtemplate",
    "iv": "application/inventor",
    "ivp": "application/immervision-ivp",
    "ivr": "i-world/i-vrml",
    "ivu": "application/immervision-ivu",
    "ivy": "application/livescreen",
    "jad": "text/sun.j2me.app-descriptor",
    "jam": "application/jam",
    "jar": "application/java-archive",
    "jav": "text/plain",
    "java": "text/java-source",
    "jcm": "application/java-commerce",
    "jdx": "chemical/jcamp-dx",
    "jfif": "image/jpg",
    "jfif-tbnl": "image/jpg",
    "jisp": "application/jisp",
    "jlt": "application/hp-jlyt",
    "jnlp": "application/java-jnlp-file",
    "joda": "application/joost.joda-archive",
    "jpe": "image/jpg",
    "jpeg": "image/jpg",
    "jpg": "image/jpg",
    "jpgm": "video/jpm",
    "jpgv": "video/jpeg",
    "jpm": "video/jpm",
    "jps": "image/jps",
    "js": "application/javascript",
    "jsd": "chemical/jsdraw",
    "jsdraw": "chemical/jsdraw",
    "json": "application/json",
    "jsonml": "application/jsonml",
    "jsonp": "application/json",
    "jhtml": "text/html",
    "jsp": "text/html",
    "jut": "image/jutvision",
    "kar": "audio/midi",
    "karbon": "application/kde.karbon",
    "kfo": "application/kde.kformula",
    "kia": "application/kidspiration",
    "kin": "chemical/kinemage",
    "kml": "application/google-earth.kml",
    "kmz": "application/google-earth.kmz",
    "kne": "application/kinar",
    "knp": "application/kinar",
    "kon": "application/kde.kontour",
    "kpr": "application/kde.kpresenter",
    "kpt": "application/kde.kpresenter",
    "kpxx": "application/ds-keypoint",
    "ksh": "application/ksh",
    "ksp": "application/kde.kspread",
    "ktr": "application/kahootz",
    "ktx": "image/ktx",
    "ktz": "application/kahootz",
    "kwd": "application/kde.kword",
    "kwt": "application/kde.kword",
    "la": "audio/nspaudio",
    "lam": "audio/liveaudio",
    "lasxml": "application/las.las",
    "latex": "application/latex",
    "lbd": "application/llamagraphics.life-balance.desktop",
    "lbe": "application/llamagraphics.life-balance.exchange",
    "les": "application/hhe.lesson-player",
    "lha": "application/lzh-compressed",
    "lhx": "application/binary",
    "link66": "application/route66.link66",
    "list": "text/plain",
    "list3820": "application/ibm.modcap",
    "listafp": "application/ibm.modcap",
    "lma": "audio/nspaudio",
    "lnk": "application/shortcut",
    "log": "text/plain",
    "lostxml": "application/lost",
    "lrf": "application/binary",
    "lrm": "application/lrm",
    "lsp": "application/lisp",
    "lst": "text/plain",
    "lsx": "text/plain",
    "ltf": "application/frogans.ltf",
    "ltx": "application/latex",
    "lvp": "audio/lucent.voice",
    "lwp": "application/lotus-wordpro",
    "lzh": "application/lzh-compressed",
    "lzma": "application/lzma",
    "lzx": "application/lzx",
    "m": "text/plain",
    "m13": "application/msmediaview",
    "m14": "application/msmediaview",
    "m1v": "video/mpeg",
    "m21": "application/mp21",
    "m2a": "audio/mpeg",
    "m2v": "video/mpeg",
    "m3a": "audio/mpeg",
    "m3u": "audio/mpegurl",
    "m3u8": "application/apple.mpegurl",
    "m4u": "video/mpegurl",
    "m4v": "video/m4v",
    "ma": "application/mathematica",
    "mads": "application/mads",
    "mag": "application/ecowin.chart",
    "maker": "application/framemaker",
    "man": "text/troff",
    "map": "application/navimap",
    "mar": "application/bzip2",
    "mathml": "application/mathml",
    "mb": "application/mathematica",
    "mbd": "application/mbedlet",
    "mbk": "application/mobius.mbk",
    "mbox": "application/mbox",
    "mc$": "application/magic-cap-package-10",
    "mc1": "application/medcalcdata",
    "mcd": "application/mcd",
    "mcf": "text/plain",
    "mcif": "chemical/mmcif",
    "mcm": "chemical/macmolecule",
    "mcp": "application/netmc",
    "mcurl": "text/curl.mcurl",
    "mdb": "application/msaccess",
    "mdi": "image/modi",
    "me": "text/troff",
    "mesh": "model/mesh",
    "meta4": "application/metalink",
    "metalink": "application/metalink",
    "mets": "application/mets",
    "mfm": "application/mfmp",
    "mft": "application/rpki-manifest",
    "mgp": "application/osgeo.mapguide.package",
    "mgz": "application/proteus.mag",
    "mht": "message/rfc822",
    "mhtml": "message/rfc822",
    "mid": "audio/midi",
    "midi": "audio/midi",
    "mie": "application/mie",
    "mif": "chemical/mif",
    "mime": "message/rfc822",
    "mj2": "video/mj2",
    "mjf": "audio/vndaudioexplosionmjuicemediafile",
    "mjp2": "video/mj2",
    "mjpg": "video/motion-jpeg",
    "mk3d": "video/matroska",
    "mka": "audio/matroska",
    "mks": "video/matroska",
    "mkv": "video/matroska",
    "mlp": "application/dolby.mlp",
    "mm": "application/meme",
    "mmd": "chemical/macromodel-input",
    "mme": "application/base64",
    "mmf": "application/smaf",
    "mmod": "chemical/macromodel-input",
    "mmr": "image/fujixerox.edmics-mmr",
    "mng": "video/mng",
    "mny": "application/msmoney",
    "mobi": "application/mobipocket-ebook",
    "mod": "audio/mod",
    "mods": "application/mods",
    "mol": "chemical/mdl-molfile",
    "mol2": "chemical/mol2",
    "moov": "video/quicktime",
    "mop": "chemical/mopac-input",
    "mov": "video/quicktime",
    "movie": "video/sgi-movie",
    "mp2": "audio/mpeg",
    "mp21": "application/mp21",
    "mp2a": "audio/mpeg",
    "mp3": "audio/mpeg",
    "mp4": "video/mp4",
    "mp4a": "audio/mp4",
    "mp4s": "application/mp4",
    "mp4v": "video/mp4",
    "mpa": "audio/mpeg",
    "mpc": "application/mophun.certificate",
    "mpe": "video/mpeg",
    "mpeg": "video/mpeg",
    "mpg": "video/mpeg",
    "mpg4": "video/mp4",
    "mpga": "audio/mpeg",
    "mpkg": "application/apple.installer",
    "mpm": "application/blueice.multipass",
    "mpn": "application/mophun.application",
    "mpp": "application/project",
    "mpt": "application/project",
    "mpv": "application/project",
    "mpx": "application/project",
    "mpy": "application/ibm.minipay",
    "mqy": "application/mobius.mqy",
    "mrc": "application/marc",
    "mrcx": "application/marcxml",
    "ms": "text/troff",
    "mscml": "application/mediaservercontrol",
    "mseed": "application/fdsn.mseed",
    "mseq": "application/mseq",
    "msf": "application/epson.msf",
    "msh": "model/mesh",
    "msi": "application/msdownload",
    "msl": "application/mobius.msl",
    "msty": "application/muvee.style",
    "mts": "model/mts",
    "mus": "application/musician",
    "musicxml": "application/recordare.musicxml",
    "mv": "video/sgi-movie",
    "mvb": "application/msmediaview",
    "mwf": "application/mfer",
    "mxf": "application/mxf",
    "mxl": "application/recordare.musicxml",
    "mxml": "application/xv",
    "mxs": "application/triscape.mxs",
    "mxu": "video/mpegurl",
    "my": "audio/make",
    "mzz": "application/vndaudioexplosionmzz",
    "n-gage": "application/nokia.n-gage.symbian.install",
    "n3": "text/n3",
    "nap": "image/naplps",
    "naplps": "image/naplps",
    "nb": "application/mathematica",
    "nbp": "application/wolfram.player",
    "nc": "application/netcdf",
    "ncm": "application/vndnokiaconfiguration-message",
    "ncx": "application/dtbncx",
    "nfo": "text/nfo",
    "ngdat": "application/nokia.n-gage.data",
    "nif": "image/niff",
    "niff": "image/niff",
    "nitf": "application/nitf",
    "nix": "application/mitransfer",
    "nlu": "application/neurolanguage.nlu",
    "nml": "application/enliven",
    "nnd": "application/noblenet-directory",
    "nns": "application/noblenet-sealer",
    "nnw": "application/noblenet-web",
    "npx": "image/net-fpx",
    "nsc": "application/conference",
    "nsf": "application/lotus-notes",
    "ntf": "application/nitf",
    "nvd": "application/navidoc",
    "nzb": "application/nzb",
    "oa2": "application/fujitsu.oasys2",
    "oa3": "application/fujitsu.oasys3",
    "oas": "application/fujitsu.oasys",
    "obd": "application/msbinder",
    "obj": "application/tgif",
    "oda": "application/oda",
    "odb": "application/database",
    "odc": "application/chart",
    "odf": "application/formula",
    "odft": "application/formula-template",
    "odg": "application/graphics",
    "odi": "application/image",
    "odm": "application/text-master",
    "odp": "application/presentation",
    "ods": "application/spreadsheet",
    "odt": "application/text",
    "oga": "audio/ogg",
    "ogg": "audio/ogg",
    "ogv": "video/ogg",
    "ogx": "application/ogg",
    "omc": "application/omc",
    "omcd": "application/omcdatamaker",
    "omcr": "application/omcregerator",
    "omdoc": "application/omdoc",
    "onepkg": "application/onenote",
    "onetmp": "application/onenote",
    "onetoc": "application/onenote",
    "onetoc2": "application/onenote",
    "opf": "application/oebps-package",
    "opml": "text/opml",
    "oprc": "application/palm",
    "org": "application/lotus-organizer",
    "osf": "application/yamaha.openscoreformat",
    "osfpvg": "application/yamaha.openscoreformat.osfpvg",
    "otc": "application/chart-template",
    "otf": "application/font-otf",
    "otg": "application/graphics-template",
    "oth": "application/text-web",
    "oti": "application/image-template",
    "otp": "application/presentation-template",
    "ots": "application/spreadsheet-template",
    "ott": "application/text-template",
    "oxps": "application/oxps",
    "p": "text/pascal",
    "p10": "application/pkcs10",
    "p12": "application/pkcs12",
    "p7a": "application/pkcs7-signature",
    "p7b": "application/pkcs7-certificates",
    "p7c": "application/pkcs7-mime",
    "p7m": "application/pkcs7-mime",
    "p7r": "application/pkcs7-certreqresp",
    "p7s": "application/pkcs7-signature",
    "p8": "application/pkcs8",
    "pac": "application/autoconfig",
    "par": "application/par2",
    "par2": "application/par2",
    "part": "application/pro_eng",
    "pas": "text/pascal",
    "paw": "application/pawaafile",
    "pbd": "application/powerbuilder6",
    "pbm": "image/portable-bitmap",
    "pcap": "application/tcpdump.pcap",
    "pcf": "application/font-pcf",
    "pcl": "application/hp-pcl",
    "pclxl": "application/hp-pclxl",
    "pct": "image/pict",
    "pcurl": "application/curl.pcurl",
    "pcx": "image/pcx",
    "pdb": "chemical/pdb",
    "pdf": "application/pdf",
    "pds": "image/pds",
    "pfa": "application/font-type1",
    "pfb": "application/font",
    "pfm": "application/font",
    "pfr": "application/font-tdpfr",
    "pfunk": "audio/make",
    "pfx": "application/pkcs12",
    "pgm": "image/portable-graymap",
    "pgn": "application/chess-pgn",
    "pgp": "application/pgp-encrypted",
    "php": "text/html",
    "pic": "image/pict",
    "pict": "image/pict",
    "pkg": "application/newton-compatible-pkg",
    "pki": "application/pkixcmp",
    "pkipath": "application/pkipkipath",
    "pko": "application/vndms-pkipko",
    "pkr": "application/pgp-signature",
    "pl": "text/plain",
    "plb": "application/3gpp.pic-bw-large",
    "plc": "application/mobius.plc",
    "plf": "application/pocketlearn",
    "plist": "application/plist",
    "pls": "application/pls",
    "plx": "application/pixclscript",
    "pm": "image/xpixmap",
    "pm4": "application/pagemaker",
    "pm5": "application/pagemaker",
    "pml": "application/ctc-posml",
    "png": "image/png",
    "pnm": "image/portable-anymap",
    "portpkg": "application/macports.portpkg",
    "pot": "application/powerpoint",
    "potm": "application/powerpoint",
    "potx": "application/mspowerpoint",
    "pov": "model/pov",
    "ppa": "application/vndms-powerpoint",
    "ppam": "application/powerpoint",
    "ppd": "application/cups-ppd",
    "ppm": "image/portable-pixmap",
    "pps": "application/powerpoint",
    "ppsm": "application/powerpoint",
    "ppsx": "application/vndms-powerpoint",
    "ppt": "application/powerpoint",
    "pptm": "application/powerpoint",
    "pptx": "application/vndms-powerpoint",
    "ppz": "application/mspowerpoint",
    "pqa": "application/palm",
    "prc": "application/mobipocket-ebook",
    "pre": "application/lotus-freelance",
    "prf": "application/pics-rules",
    "prt": "application/pro_eng",
    "ps": "application/postscript",
    "psb": "application/3gpp.pic-bw-small",
    "psd": "image/adobe.photoshop",
    "psf": "application/msdownload",
    "pskcxml": "application/pskc",
    "ptid": "application/pvi.ptid1",
    "pub": "application/mspublisher",
    "pvb": "application/3gpp.pic-bw-var",
    "pvu": "paleovu/pv",
    "pwn": "application/3m.post-it-notes",
    "pwz": "application/vndms-powerpoint",
    "py": "text/plain",
    "pya": "audio/playready.media.pya",
    "pyv": "video/playready.media.pyv",
    "qam": "application/epson.quickanime",
    "qbo": "application/intu.qbo",
    "qcp": "audio/vndqcelp",
    "qd3": "world/3dmf",
    "qd3d": "world/3dmf",
    "qfx": "application/intu.qfx",
    "qif": "image/quicktime",
    "qps": "application/publishare-delta-tree",
    "qt": "video/quicktime",
    "qtc": "video/qtc",
    "qti": "image/quicktime",
    "qtif": "image/quicktime",
    "qwd": "application/quark",
    "qwt": "application/quark",
    "qxb": "application/quark",
    "qxd": "application/quark",
    "qxl": "application/quark",
    "qxt": "application/quark",
    "ra": "audio/pn-realaudio",
    "ram": "audio/pn-realaudio",
    "rar": "application/rar-compressed",
    "ras": "image/cmu-raster",
    "rast": "image/cmu-raster",
    "rcprofile": "application/ipunplugged.rcprofile",
    "rd": "chemical/mdl-rdfile",
    "rdf": "application/rdf",
    "rdz": "application/data-vision.rdz",
    "rep": "application/businessobjects",
    "res": "application/dtbresource",
    "rexx": "text/plain",
    "rf": "image/vndrn-realflash",
    "rgb": "image/rgb",
    "rif": "application/reginfo",
    "rip": "audio/rip",
    "ris": "application/research-info-systems",
    "rl": "application/resource-lists",
    "rlc": "image/fujixerox.edmics-rlc",
    "rld": "application/resource-lists-diff",
    "rm": "application/rn-realmedia",
    "rmi": "audio/midi",
    "rmm": "audio/pn-realaudio",
    "rmp": "audio/pn-realaudio-plugin",
    "rms": "application/jcp.javame.midlet-rms",
    "rmvb": "application/rn-realmedia-vbr",
    "rnc": "application/relang-compact-syntax",
    "rng": "application/vndnokiaringing-tone",
    "rnx": "application/vndrn-realplayer",
    "roa": "application/rpki-roa",
    "roff": "text/troff",
    "rp": "image/vndrn-realpix",
    "rp9": "application/cloanto.rp9",
    "rpkg": "application/binary",
    "rpm": "application/rpm",
    "rpss": "application/nokia.radio-presets",
    "rpst": "application/nokia.radio-preset",
    "rq": "application/sparql-query",
    "rs": "application/rls-services",
    "rsd": "application/rsd",
    "rss": "application/rss",
    "rt": "application/rtf",
    "rtf": "application/rtf",
    "rtx": "text/richtext",
    "rv": "video/vndrn-realvideo",
    "rxn": "chemical/mdl-rxnfile",
    "s": "text/asm",
    "s3m": "audio/s3m",
    "s7z": "application/7z-compressed",
    "saf": "application/yamaha.smaf-audio",
    "saveme": "application/octet-stream",
    "sbk": "application/tbook",
    "sbml": "application/sbml",
    "sc": "application/ibm.secure-container",
    "scd": "application/msschedule",
    "scm": "application/lotus-screencam",
    "scq": "application/scvp-cv-request",
    "scs": "application/scvp-cv-response",
    "scurl": "text/curl.scurl",
    "sd": "chemical/mdl-sdfile",
    "sda": "application/draw",
    "sdc": "application/spreadsheet",
    "sdd": "application/presentation",
    "sdf": "chemical/mdl-sdfile",
    "sdkd": "application/solent.sdkm",
    "sdkm": "application/solent.sdkm",
    "sdml": "text/plain",
    "sdp": "application/sdp",
    "sdr": "application/sounder",
    "sdw": "application/writer",
    "sea": "application/sea",
    "see": "application/seemail",
    "seed": "application/fdsn.seed",
    "sema": "application/sema",
    "semd": "application/semd",
    "semf": "application/semf",
    "ser": "application/java-serialized-object",
    "set": "application/set",
    "setpay": "application/set-payment-initiation",
    "setreg": "application/set-registration-initiation",
    "sfd-hdstx": "application/hydrostatix.sof-data",
    "sfs": "application/spotfire.sfs",
    "sfv": "text/sfv",
    "sgi": "image/sgi",
    "sgl": "application/writer",
    "sgm": "text/sgml",
    "sgml": "text/sgml",
    "sh": "application/sh",
    "shar": "application/shar",
    "shf": "application/shf",
    "shtml": "text/html",
    "sid": "image/mrsid-image",
    "sig": "application/pgp-signature",
    "sil": "audio/silk",
    "silo": "model/mesh",
    "sis": "application/symbian",
    "sisx": "application/symbian",
    "sit": "application/stuffit",
    "sitx": "application/stuffit",
    "skd": "application/koan",
    "skm": "application/koan",
    "skp": "application/koan",
    "skr": "application/pgp-signature",
    "skt": "application/koan",
    "sl": "application/seelogo",
    "sldm": "application/powerpoint.slide.macroenabled.12",
    "sldx": "application/vndms-powerpoint",
    "slt": "application/epson.salt",
    "sm": "application/stepmania.stepchart",
    "smf": "application/math",
    "smi": "application/smil",
    "smil": "application/smil",
    "smv": "video/smv",
    "smzip": "application/stepmania.package",
    "snd": "audio/basic",
    "snf": "application/font-snf",
    "so": "application/binary",
    "sol": "application/solids",
    "spc": "chemical/galactic-spc",
    "spf": "application/yamaha.smaf-phrase",
    "spl": "application/futuresplash",
    "spot": "text/in3d.spot",
    "spp": "application/scvp-vp-response",
    "spq": "application/scvp-vp-request",
    "spr": "application/sprite",
    "sprite": "application/sprite",
    "spx": "audio/ogg",
    "sql": "application/sql",
    "src": "application/wais-source",
    "srt": "application/subrip",
    "sru": "application/sru",
    "srx": "application/sparql-results",
    "ssdl": "application/ssdl",
    "sse": "application/kodak-descriptor",
    "ssf": "application/epson.ssf",
    "ssi": "text/html",
    "ssm": "application/streamingmedia",
    "ssml": "application/ssml",
    "sst": "application/vndms-pkicertstore",
    "st": "application/sailingtracker.track",
    "stc": "application/spreadsheet.template",
    "std": "application/draw.template",
    "step": "application/step",
    "stf": "application/wt.stf",
    "sti": "application/presentation.template",
    "stk": "application/hyperstudio",
    "stl": "application/pki.stl",
    "stp": "application/step",
    "str": "application/pg.format",
    "stw": "application/writer.template",
    "sub": "text/dvb.subtitle",
    "sus": "application/sus-calendar",
    "susp": "application/sus-calendar",
    "sv4cpio": "application/sv4cpio",
    "sv4crc": "application/sv4crc",
    "svc": "application/dvb.service",
    "svd": "application/svd",
    "svg": "image/svg",
    "svgz": "image/svg",
    "svr": "application/world",
    "sw": "chemical/swissprot",
    "swa": "application/director",
    "swf": "application/shockwave-flash",
    "swi": "application/aristanetworks.swi",
    "sxc": "application/spreadsheet",
    "sxd": "application/draw",
    "sxg": "application/writer",
    "sxi": "application/presentation",
    "sxm": "application/math",
    "sxw": "application/writer",
    "t": "text/troff",
    "t3": "application/t3vm-image",
    "taglet": "application/mynfc",
    "talk": "text/plain",
    "tao": "application/tao.intent-module-archive",
    "tar": "application/tar",
    "tbk": "application/toolbook",
    "tcap": "application/3gpp2.tcap",
    "tcl": "application/tcl",
    "tcsh": "text/plain",
    "teacher": "application/smart.teacher",
    "tei": "application/tei",
    "teicorpus": "application/tei",
    "tex": "application/tex",
    "texi": "application/texinfo",
    "texinfo": "application/texinfo",
    "text": "text/plain",
    "tfi": "application/thraud",
    "tfm": "application/tetfm",
    "tga": "image/tga",
    "tgf": "chemical/mdl-tgf",
    "tgz": "application/compressed",
    "thmx": "application/officetheme",
    "tif": "image/tiff",
    "tiff": "image/tiff",
    "tmo": "application/tmobile-livetv",
    "torrent": "application/bittorrent",
    "tpl": "application/groove-tool-template",
    "tpt": "application/trid.tpt",
    "tr": "text/troff",
    "tra": "application/trueapp",
    "trm": "application/msterminal",
    "tsd": "application/timestamped-data",
    "tsi": "audio/tsp-audio",
    "tsp": "application/dsptype",
    "tsv": "text/tab-separated-values",
    "ttc": "application/font",
    "ttf": "application/font",
    "ttl": "text/turtle",
    "turbot": "image/florian",
    "twd": "application/simtech-mindmapper",
    "twds": "application/simtech-mindmapper",
    "txd": "application/genomatix.tuxedo",
    "txf": "application/mobius.txf",
    "txt": "text/plain",
    "u32": "application/authorware-bin",
    "udeb": "application/deb",
    "ufd": "application/ufdl",
    "ufdl": "application/ufdl",
    "uil": "text/plain",
    "ulx": "application/glulx",
    "umj": "application/umajin",
    "uni": "text/plain",
    "unis": "text/plain",
    "unityweb": "application/unity",
    "unv": "application/i-deas",
    "uoml": "application/uoml",
    "uri": "text/uri-list",
    "uris": "text/uri-list",
    "urls": "text/uri-list",
    "ustar": "application/ustar",
    "utz": "application/uiq.theme",
    "uu": "text/uuencode",
    "uue": "text/plain",
    "uva": "audio/dece",
    "uvd": "application/dece",
    "uvf": "application/dece",
    "uvg": "image/dece",
    "uvh": "video/dece",
    "uvi": "image/dece",
    "uvm": "video/dece",
    "uvp": "video/dece",
    "uvs": "video/dece",
    "uvt": "application/dece",
    "uvu": "video/uvvu.mp4",
    "uvv": "video/dece",
    "uvva": "audio/dece",
    "uvvd": "application/dece",
    "uvvf": "application/dece",
    "uvvg": "image/dece",
    "uvvh": "video/dece",
    "uvvi": "image/dece",
    "uvvm": "video/dece",
    "uvvp": "video/dece",
    "uvvs": "video/dece",
    "uvvt": "application/dece",
    "uvvu": "video/uvvu.mp4",
    "uvvv": "video/dece.video",
    "uvvx": "application/dece",
    "uvvz": "application/dece",
    "uvx": "application/dece",
    "uvz": "application/dece",
    "val": "chemical/ncbi-asn1-binary",
    "vcard": "text/vcard",
    "vcd": "application/cdlink",
    "vcf": "text/vcard",
    "vcg": "application/groove-vcard",
    "vcs": "text/vcalendar",
    "vcx": "application/vcx",
    "vda": "application/vda",
    "vdo": "video/vdo",
    "vew": "application/groupwise",
    "vf": "application/fnt",
    "vis": "application/visionary",
    "viv": "video/vivo",
    "vivo": "au/twinvq",
    "vmd": "chemical/vmd",
    "vmf": "application/vocaltec-media-file",
    "vms": "chemical/vamas-iso14976",
    "vob": "video/vob",
    "voc": "audio/voc",
    "vor": "application/writer",
    "vos": "video/vosaic",
    "vox": "application/authorware-bin",
    "vqe": "audio/twinvq-plugin",
    "vqf": "audio/twinvq",
    "vql": "audio/twinvq-plugin",
    "vrml": "model/vrml",
    "vrt": "world/vrt",
    "vsd": "application/visio",
    "vsf": "application/vsf",
    "vss": "application/visio",
    "vst": "application/visio",
    "vsw": "application/visio",
    "vtu": "model/vtu",
    "vxml": "application/voicexml",
    "w3d": "application/director",
    "w60": "application/wordperfect60",
    "w61": "application/wordperfect61",
    "w6w": "application/word",
    "wad": "application/doom",
    "war": "application/java-archive",
    "wav": "audio/wav",
    "wax": "audio/wax",
    "wb1": "application/qpro",
    "wbmp": "image/wap.wbmp",
    "wbs": "application/criticaltools.wbs",
    "wbxml": "application/wap.wbxml",
    "wcm": "application/works",
    "wdb": "application/works",
    "wdp": "image/photo",
    "web": "application/vndxara",
    "weba": "audio/webm",
    "webm": "video/webm",
    "webp": "image/webp",
    "wg": "application/pmi.widget",
    "wgt": "application/widget",
    "wiz": "application/word",
    "wk1": "application/123",
    "wks": "application/works",
    "wm": "video/wm",
    "wma": "audio/wma",
    "wmd": "application/wmd",
    "wmf": "application/msmetafile",
    "wml": "text/wap.wml",
    "wmlc": "application/wap.wmlc",
    "wmls": "text/wap.wmlscript",
    "wmlsc": "application/wap.wmlscriptc",
    "wmv": "video/wmv",
    "wmx": "video/wmx",
    "wmz": "application/msmetafile",
    "woff": "application/font-woff",
    "woff2": "application/font-woff2",
    "word": "application/word",
    "wp": "application/wordperfect",
    "wp5": "application/wordperfect",
    "wp6": "application/wordperfect",
    "wpd": "application/wordperfect",
    "wpl": "application/wpl",
    "wps": "application/works",
    "wq1": "application/lotus",
    "wqd": "application/wqd",
    "wri": "application/mswrite",
    "wrl": "model/vrml",
    "wrz": "model/vrml",
    "wsc": "text/plain",
    "wsdl": "application/wsdl",
    "wspolicy": "application/wspolicy",
    "wsrc": "application/wais-source",
    "wtb": "application/webturbo",
    "wtk": "application/wintalk",
    "wvx": "video/wvx",
    "wys": "text/config",
    "wyu": "text/config",
    "x32": "application/authorware-bin",
    "x3d": "model/x3d",
    "x3db": "model/x3d+binary",
    "x3dbz": "model/x3d+binary",
    "x3dv": "model/x3d+vrml",
    "x3dvz": "model/x3d+vrml",
    "x3dz": "model/x3d",
    "xaml": "application/xaml",
    "xap": "application/silverlight-app",
    "xar": "application/xara",
    "xbap": "application/xbap",
    "xbd": "application/fujixerox.docuworks.binder",
    "xbm": "image/xbitmap",
    "xdf": "application/xcap-diff",
    "xdm": "application/syncml.dm",
    "xdp": "application/adobe.xdp",
    "xdr": "video/amt-demorun",
    "xdssc": "application/dssc",
    "xdw": "application/fujixerox.docuworks",
    "xenc": "application/xenc",
    "xer": "application/patch-ops-error",
    "xfdf": "application/adobe.xfdf",
    "xfdl": "application/xfdl",
    "xgz": "xgl/drawing",
    "xht": "application/xhtml",
    "xhtml": "application/xhtml",
    "xhvml": "application/xv",
    "xif": "image/xiff",
    "xl": "application/excel",
    "xla": "application/excel",
    "xlam": "application/excel",
    "xlb": "application/excel",
    "xlc": "application/excel",
    "xld": "application/excel",
    "xlf": "application/xliff",
    "xlk": "application/excel",
    "xll": "application/vndms-excel",
    "xlm": "application/excel",
    "xls": "application/excel",
    "xlsb": "application/excel",
    "xlsm": "application/excel",
    "xlsx": "application/excel",
    "xlt": "application/excel",
    "xltm": "application/excel",
    "xltx": "application/excel",
    "xlv": "application/excel",
    "xlw": "application/excel",
    "xm": "audio/xm",
    "xml": "application/xml",
    "xmz": "xgl/movie",
    "xo": "application/olpc-sugar",
    "xop": "application/xop",
    "xpi": "application/xpinstall",
    "xpix": "application/vndls-xpix",
    "xpl": "application/xproc",
    "xpm": "image/xpixmap",
    "xpr": "application/is-xpr",
    "xps": "application/xpsdocument",
    "xpw": "application/intercon.formnet",
    "xpx": "application/intercon.formnet",
    "xsl": "application/xml",
    "xslt": "application/xslt",
    "xsm": "application/syncml",
    "xspf": "application/xspf",
    "xsr": "video/amt-showrun",
    "xtel": "chemical/xtel",
    "xul": "application/mozilla.xul",
    "xvm": "application/xv",
    "xvml": "application/xv",
    "xwd": "image/xwindowdump",
    "xyz": "chemical/xyz",
    "xz": "application/xz",
    "yaml": "application/yaml",
    "yang": "application/yang",
    "yin": "application/yin",
    "z": "application/compressed",
    "z1": "application/zmachine",
    "z2": "application/zmachine",
    "z3": "application/zmachine",
    "z4": "application/zmachine",
    "z5": "application/zmachine",
    "z6": "application/zmachine",
    "z7": "application/zmachine",
    "z8": "application/zmachine",
    "zaz": "application/zzazz.deck",
    "zip": "application/zip",
    "zir": "application/zul",
    "zirz": "application/zul",
    "zmm": "application/handheld-entertainment",
    "zoo": "application/zoo",
    "zsh": "application/zsh"
}