from uraltimber.extractor import Extractor


class DeeplTranslate(Extractor):
    domain_name = 'deepl.com'
    search_keys = ('query',)


class GoogleTranslate(Extractor):
    domain_name = 'translate.google'
    search_keys = ('q', 'text')


class YandexTranslate(Extractor):
    domain_name = 'translate.yandex'
    search_keys = ('text',)


__all__ = (
    'DeeplTranslate',
    'GoogleTranslate',
    'YandexTranslate',
)
