from uraltimber.extractor import Extractor
from ..settings import re_icompile


class FaceBook(Extractor):
    domain_name = 'facebook.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'graph\.facebook\.com/'),)


class LinkedIn(Extractor):
    domain_name = 'linkedin.com'
    search_keys = ('keywords',)


class Mastodon(Extractor):
    domain_name = 'mastodon.social'
    search_keys = ('q',)


class Pinterest(Extractor):
    domain_name = 'pinterest.com'
    search_keys = (
        'q',
        'query',
        'search_query',
    )
    exclude_patterns = (re_icompile(r'search/autocomplete'),)


class Twitter(Extractor):
    domain_name = 'twitter.com'
    search_keys = ('q',)
    exclude_patterns = (
        re_icompile(r'(platform|syndication|analytics)\.twitter\.com/'),
        re_icompile(r'typeahead'),
    )


__all__ = (
    'FaceBook',
    'LinkedIn',
    'Mastodon',
    'Pinterest',
    'Twitter',
)
