from uraltimber.extractor import Extractor
from ..settings import re_icompile


class About(Extractor):
    domain_name = 'about.com'
    search_keys = ('q',)


class Alhea(Extractor):
    domain_name = 'alhea.com'
    search_keys = ('q',)


class AOL(Extractor):
    domain_name = 'aol.com'
    search_keys = ('q',)


class AVG(Extractor):
    domain_name = 'avg.com'
    search_keys = ('q', 'p')
    exclude_patterns = (re_icompile(r'avg.com/api/acp'),)


class Baidu(Extractor):
    domain_name = 'baidu.com'
    search_keys = ('wd',)
    exclude_patterns = (re_icompile(r'baidu.com/sugrec'),)


class Bing(Extractor):
    domain_name = 'bing.com'
    search_keys = ('q',)
    exclude_patterns = (
        re_icompile(r'bing.com/(osjson.aspx|rewardsapp|persistent|hamburger|as/suggestions)'),
    )


class Brave(Extractor):
    domain_name = 'search.brave.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'brave.com/api/suggest'),)


class BraveSafe(Extractor):
    domain_name = 'safe.search.brave.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'brave.com/api/suggest'),)


class Clearch(Extractor):
    domain_name = 'search.clearch.org'
    search_keys = ('q',)


class DogPile(Extractor):
    domain_name = 'dogpile.com'
    search_keys = ('q',)


class DuckDuckGo(Extractor):
    domain_name = 'duckduckgo.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'duckduckgo\.com/ac|//(ac|icons|improving).duckduckgo.com'),)


class Ecosia(Extractor):
    domain_name = 'ecosia.org'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'ac.ecosia.org'),)


class EntireWeb(Extractor):
    domain_name = 'entireweb.com'
    search_keys = ('q',)


class Google(Extractor):
    domain_name = 'google'
    exclude_patterns = (
        re_icompile(r'(pay|wallet|drive|docs|accounts|maps|checkout|translate|support)\.google'),
        re_icompile(r'complete/search'),
        re_icompile(r'maps'),
        re_icompile(r'/(async|afs)/'),
        re_icompile(r'earth/rpc/suggest'),
        re_icompile(r'/(drive|docs|g?mail|checkout|client)'),
    )
    search_keys = ('q',)


class Gibiru(Extractor):
    domain_name = 'gibiru.com'
    search_keys = ('q',)


class GiveWater(Extractor):
    domain_name = 'search.givewater.com'
    search_keys = ('q',)


class Info(Extractor):
    domain_name = 'info.com'
    search_keys = ('qkw',)


class InfoSpace(Extractor):
    domain_name = 'infospace.com'
    search_keys = ('q',)


class Kagi(Extractor):
    domain_name = 'kagi.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'kagi.com/autosuggest'),)


class KidzSearch(Extractor):
    domain_name = 'search.kidzsearch.com'
    search_keys = ('q',)


class MyWebSearch(Extractor):
    domain_name = 'mywebsearch.com'
    search_keys = ('searchfor',)


class Presearch(Extractor):
    domain_name = 'presearch.com'
    search_keys = ('q',)


class Seekr(Extractor):
    domain_name = 'news.seekr.com'
    search_keys = ('query',)


class SwissCows(Extractor):
    domain_name = 'swisscows.com'
    search_keys = ('query',)
    exclude_patterns = (re_icompile(r'swisscows.com/api/suggest'),)


class TheSearchWay(Extractor):
    domain_name = 'thesearchway.com'
    search_keys = ('key',)


class Qwant(Extractor):
    domain_name = 'qwant.com'
    search_keys = ('q',)
    exclude_patterns = (re_icompile(r'qwant.com/api/suggest'),)


class WebCrawler(Extractor):
    domain_name = 'webcrawler.com'
    search_keys = ('q',)


class WOW(Extractor):
    domain_name = 'wow.com'
    search_keys = ('q',)


class WPSafeSearch(Extractor):
    domain_name = 'wpsafesearch.com'
    search_keys = ('q',)


class Yahoo(Extractor):
    domain_name = 'search.yahoo.com'
    search_keys = ('p',)
    exclude_patterns = (re_icompile(r'yahoo.com/sugg'),)


class Yandex(Extractor):
    domain_name = 'yandex'
    search_keys = ('text',)


__all__ = (
    'About',
    'Alhea',
    'AOL',
    'AVG',
    'Baidu',
    'Bing',
    'Brave',
    'BraveSafe',
    'DogPile',
    'DuckDuckGo',
    'Ecosia',
    'EntireWeb',
    'Gibiru',
    'GiveWater',
    'Google',
    'Info',
    'InfoSpace',
    'MyWebSearch',
    'Presearch',
    'Qwant',
    'Seekr',
    'TheSearchWay',
    'WebCrawler',
    'WOW',
    'WPSafeSearch',
    'Yahoo',
    'Yandex',
)
