from uraltimber.extractor import Extractor

from ..settings import re_icompile
from ..typehints import URLPath


class Answers(Extractor):
    domain_name = 'answers.com'
    search_keys = ('q', 'Q')
    exclude_patterns = (
        re_icompile(r'answers\.com/Q/(FAQ|Special)'),
    )

    # http://answers.com/question/what-is-ssd-memory
    search_patterns = (
        URLPath(2, re_icompile(r'^/(question|Q|search)/(.*)')),
    )


class Britannica(Extractor):
    domain_name = 'britannica.com'
    search_keys = ('query',)

    # http://www.britannica.com/event/Battle-of-the-Coral-Sea
    search_patterns = (
        URLPath(2, re_icompile(r'^/(story|event|biography|quiz|search)/(.*)')),
    )


class Encyclopedia(Extractor):
    domain_name = 'encyclopedia.com'
    search_keys = ('q',)


class Reference(Extractor):
    domain_name = 'reference.com'
    search_keys = ('q',)
    search_patterns = (
        URLPath(2, re_icompile(r'^/(browse|web)/(.*)')),
    )


class Thesaurus(Extractor):
    domain_name = 'thesaurus.com'
    # http://www.thesaurus.com/browse/oeuvre?s=t
    search_patterns = (
        URLPath(1, re_icompile(r'^/browse/(.*)')),
    )
    search_keys = ('q', 'term')


class Wiktionary(Extractor):
    domain_name = 'wiktionary.org'
    search_keys = ()
    exclude_patterns = (
        re_icompile(r'^/(special|portal|wiktionary)'),
    )
    # https://en.wiktionary.org/wiki/ampersand
    search_patterns = (
        URLPath(1, re_icompile(r'^/wiki/(.*)')),
    )


class Wikipedia(Extractor):
    domain_name = 'wikipedia.org'
    search_keys = ('search',)
    exclude_patterns = (
        re_icompile(r'^/(special|portal|wikipedia|count-search)'),
    )

    title_patterns = (
        # /api/rest_v1/page/summary/Ernst_Lissner
        URLPath(1, re_icompile(r'^/api/rest_v\d/page/summary/(.*)')),

        # /wiki/Python_(programming_language)
        URLPath(1, re_icompile(r'^/wiki/(.*)')),
    )


class WolframAlpha(Extractor):
    domain_name = 'wolframalpha.com'
    search_keys = ('i',)


__all__ = (
    'Answers',
    'Britannica',
    'Encyclopedia',
    'Reference',
    'Thesaurus',
    'Wikipedia',
    'Wiktionary',
    'WolframAlpha',
)
