from uraltimber.extractor import Extractor
from ..settings import re_icompile
from ..typehints import URLPath


class Adobe(Extractor):
    domain_name = 'adobe.com'
    search_keys = ('k',)


class CanStockPhoto(Extractor):
    domain_name = 'canstockphoto.com'
    search_keys = ()

    # http://www.canstockphoto.com/images-photos/blue-roses.html#file_view.php?id=0589707
    search_patterns = (
        URLPath(2, re_icompile(r'^/(photos?-images|images-photos|stock-footage)/(.*)\.html')),
    )


class DreamsTime(Extractor):
    domain_name = 'dreamstime.com'
    search_keys = ()

    # http://www.dreamstime.com/images-photos/blue-roses.html#file_view.php?id=0589707
    search_patterns = (
        URLPath(2, re_icompile(r'^/(photos?-images|images-photos|stock-footage)/(.*)\.html')),
    )


class Flickr(Extractor):
    domain_name = 'flickr.com'
    search_keys = ('gq',)


class Fotolia(Extractor):
    domain_name = 'fotolia.com'
    search_keys = ('k',)


class GettyImages(Extractor):
    domain_name = 'gettyimages.com'
    search_keys = ('phrase',)


class iStockPhoto(Extractor):
    domain_name = 'istockphoto.com'
    search_keys = ('phrase',)


class Pixabay(Extractor):
    domain_name = 'pixabay.com'
    search_keys = ()

    # https://pixabay.com/images/search/highland%20cattle/
    # https://pixabay.com/illustrations/search/lamp%20logo/?pagi=2
    search_patterns = (URLPath(1, re_icompile(r'^/\w+/search/(.*)/')),)


class ShutterStock(Extractor):
    domain_name = 'shutterstock.com'
    search_keys = ('q',)


class StockSy(Extractor):
    domain_name = 'stocksy.com'
    search_keys = ('text',)


class StockPhoto(Extractor):
    domain_name = 'bstockphoto.com'
    search_keys = ('q',)


class ThinkStockPhotos(Extractor):
    domain_name = 'thinkstockphotos.com'
    search_keys = ('q',)

    # http://www.thinkstockphotos.com/search/#trailer/f=CPIHVX/s=DynamicRank
    fragment_patterns = (URLPath(1, re_icompile(r'^([a-z0-9\-\_]+)/')),)


class Unsplash(Extractor):
    domain_name = 'unsplash.com'
    search_keys = ()

    # https://unsplash.com/s/photos/brain-scan
    # https://unsplash.com/s/illustrations/rose-garden
    search_patterns = (URLPath(2, re_icompile(r'^/s/(illustrations|photos)/(.*)$')),)


__all__ = (
    'Adobe',
    'CanStockPhoto',
    'DreamsTime',
    'Flickr',
    'Fotolia',
    'GettyImages',
    'ShutterStock',
    'StockPhoto',
    'StockSy',
    'ThinkStockPhotos',
    'Unsplash',
)
