from uraltimber.extractor import Extractor
from ..settings import re_icompile
from ..typehints import URLPath


class AmazonMusic(Extractor):
    domain_name = 'music.amazon.com'

    # https://music.amazon.com/search/handels+messiah?filter=IsLibrary%7Cfalse&sc=none
    search_patterns = (URLPath(1, re_icompile(r"^/search/([\w|\%|\d|'|\+]+)[?/]?")),)


class Deezer(Extractor):
    domain_name = 'deezer.com/search'
    search_keys = ('q',)


class Spotify(Extractor):
    domain_name = 'spotify.com/search'

    # https://open.spotify.com/search/handel's%20messiah
    search_patterns = (URLPath(1, re_icompile(r"^/search/([\w|\%|\d|'|\+]+)[?/]?")),)


__all__ = (
    'AmazonMusic',
    'Deezer',
    'Spotify',
)
