from uraltimber.extractor import Extractor
from ..cache import (
    cached_property,
)
from ..settings import re_icompile


class GoogleMapsPlaces(Extractor):
    """
    Extract place names from Google Maps URLs
    https://www.google.com/maps/place/Mt+Vernon,+IL+62864/@38.3113877,-88.9355762,13z/data=!3m1!4b1!4m5!3m4!1s0x8876b7da11fabfc3:0x6b49c11970ac421b!8m2!3d38.3172714!4d-88.9031201
    """
    domain_name = 'google.com/maps/place'
    place = re_icompile(r'place/(.+)/@')

    @cached_property
    def search_term_from_path(self) -> str:
        if place_match := self.place.search(self.url):
            return place_match.group(1)
        return ''

    @cached_property
    def path_extension(self) -> str:
        return ''


class MapQuest(Extractor):
    domain_name = 'mapquest.com'
    search_keys = ('query',)


class OpenStreetMap(Extractor):
    domain_name = 'openstreetmap.org'
    search_keys = ('query',)


__all__ = (
    'GoogleMapsPlaces',
    'MapQuest',
    'OpenStreetMap',
)
