from uraltimber.extractor import Extractor
from ..settings import re_icompile
from ..typehints import URLPath


class Amazon(Extractor):
    domain_name = 'amazon'
    exclude_patterns = (
        re_icompile(r'complet(e|ion)\.amazon\.(com|ca)'),
        re_icompile(r'searchautocomplete'),
    )
    search_keys = (
        'k',
        'keywords',
        'field-keywords',
    )
    title_patterns = (URLPath(1, re_icompile(r'^/([\w\d\-]+)/dp/')),)


class BassPro(Extractor):
    domain_name = 'basspro.com'
    search_keys = ('searchTerm',)
    min_title_length = 20

    title_patterns = (URLPath(1, re_icompile(r'^/shop/\w{2}/([\w\d\-]+)')),)


class Cabelas(Extractor):
    domain_name = 'cabelas'
    search_keys = ('CQ_search',)
    min_title_length = 20

    title_patterns = (
        URLPath(1, re_icompile(r'^/category/([\w\d\-]+)/')),
        URLPath(1, re_icompile(r'^/product(?:/\d+)?/([\w\d\-]+)')),
    )


class BedBathandBeyond(Extractor):
    domain_name = 'bedbathandbeyond.com'
    search_patterns = (URLPath(1, re_icompile(r'^/store/s/([\w\d\-]+)')),)

    title_patterns = (URLPath(1, re_icompile(r'^/store/product/([\w\d\-]+)')),)


class CraigsList(Extractor):
    domain_name = 'craigslist.org'
    exclude_patterns = (re_icompile(r'craigslist\.org/count\-search'),)
    search_keys = ('query',)

    # https://philadelphia.craigslist.org/cps/d/50-flat-rate-computer-repair/6741111374.html
    title_patterns = (URLPath(1, re_icompile(r'^/[\w]{3}/\w/(.*)/')),)


class CanadianTire(Extractor):
    domain_name = 'canadiantire.ca'
    exclude_patterns = (re_icompile(r'\bcanadiantire.ca/.*/suggest\b'),)
    search_keys = ('q',)


class EBay(Extractor):
    domain_name = 'ebay'
    search_keys = ('_nkw',)
    title_patterns = (URLPath(1, re_icompile(r'^/itm/([\w\d\-]+)/')),)
    exclude_patterns = (re_icompile(r'autosug.ebay.com'),)


class JCPenney(Extractor):
    domain_name = 'jcpenney.com'
    search_keys = ('Ntt',)

    title_patterns = (URLPath(1, re_icompile(r'^/p/([\w\d\-]+)')),)


class Macys(Extractor):
    domain_name = 'macys.com'

    search_patterns = (URLPath(1, re_icompile(r'^/shop/featured/([\w\d\-]+)')),)

    title_patterns = (URLPath(1, re_icompile(r'^/shop/product/([\w\d\-]+)')),)


class Target(Extractor):
    domain_name = 'target.com'
    search_keys = ('search', 'searchTerm')

    title_patterns = (URLPath(1, re_icompile(r'^/[cp]/([\w\d\-]+)/')),)


class WalMart(Extractor):
    domain_name = 'walmart.com'
    search_keys = ('query',)


__all__ = (
    'Amazon',
    'BedBathandBeyond',
    'BassPro',
    'Cabelas',
    'CraigsList',
    'EBay',
    'JCPenney',
    'Macys',
    'Target',
    'WalMart',
)
