from uraltimber.extractor import Extractor
from ..settings import re_icompile
from ..typehints import URLPath


class You(Extractor):
    domain_name = 'you.com/search'
    search_keys = ('q',)


class Komo(Extractor):
    domain_name = 'komo.ai/api/opinions'
    search_keys = ('xsw',)


class Perplexity(Extractor):
    """
    Params are mostly passed in POST body, but URL is updated
    after the page finishes loading. And then if that URL is
    ever retrieved via GET, at least a truncated version of the
    original query can be extracted.
    """
    domain_name = 'perplexity.ai/search'
    search_keys = ()

    # https://www.perplexity.ai/search/how-to-train-sklearn-svm-S6WekqQkQCiKeiP9qYYOdw
    # https://www.perplexity.ai/search/train-sklearn-to-detect-phishi-nR5wHrfBQjSGNu8ynkJHbA
    search_patterns = (URLPath(1, re_icompile(r'/search/([a-z-]+)-\w+$')),)


__all__ = (
    'You',
    'Komo',
    'Perplexity',
)
