#!/usr/bin/python3
# -*- coding: utf-8 -*-

import io
import re
import os
from os.path import dirname, join

from setuptools import setup, find_packages


def read(*names, **kwargs):
    return io.open(join(dirname(__file__), *names), encoding=kwargs.get('encoding', 'utf8')).read()


def get_version():
    with open('uraltimber/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of uraltimber")

        version = match.group(1)
        return version


def get_packages(package):
    """
    Return root package and all sub-packages.
    """
    return [
        dirpath for dirpath, dirnames, filenames in os.walk(package)
        if os.path.exists(os.path.join(dirpath, '__init__.py'))
    ]


setup(
    name='uraltimber',
    version=get_version(),
    license='SAP',
    description='Extract Query and Title information from URLs',
    long_description='%s\n%s' % (
        re.compile(r'^.. start-badges.*^.. end-badges', re.M | re.S).sub('', read('README.md')),
        re.sub(r':[a-z]+:`~?(.*?)`', r'``\1``', read('CHANGELOG.md'))
    ),
    long_description_content_type='text/markdown',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='https://code.compassfoundation.io/dave/uraltimber',
    packages=find_packages(),
    package_data={
        'uraltimber': ['*.csv', '*.json'],
    },
    zip_safe=True,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: SAP',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Utilities',
    ],
    keywords=[
        'Security Appliance',
        'Log Cabin',
    ],
    install_requires=[
        'lclazy',
        'lchttp',
        'publicsuffixlist',
    ],
)
