import time
from urllib.parse import urlparse

if __name__ == '__main__':
    with open('domains.txt', 'r') as doms:
        domains = [d.strip() for d in doms.readlines()]

    start = time.time()

    for dom in domains:
        try:
            urlparse(dom)
        except ValueError:
            continue

    print(f'urlparse took {time.time() - start} seconds')
