import time
from purl import URL
from functools import lru_cache

@lru_cache(512)
def _url(url):
    return URL(dom)


if __name__ == '__main__':
    with open('domains.txt', 'r') as doms:
        domains = [d.strip() for d in doms.readlines()]

    start = time.time()

    for dom in domains:
        try:
            _url(dom)
        except ValueError:
            continue

    print(f'yarl took {time.time() - start} seconds')
