from django.core.exceptions import ValidationError
from . import keys


def validate_public_key(keystr: str) -> None:
    """
    Check that the given value is a valid public key in either PEM or OpenSSH format.
    If it is invalid, raises ``django.core.exceptions.ValidationError``.
    """
    key_bytes = keystr.encode()
    exc, key = keys.PublicKey.load_serialized_public_key(key_bytes)
    is_valid = (exc is None) and (key is not None)
    if not is_valid:
        raise ValidationError(f"Public key is invalid: {exc}")


__all__ = [
    'validate_public_key',
]
