import base64
from aspen_crypto.keys import load_private_key
import struct
from typing import List

from django.conf import settings


def get_key_password(cid, ssh=False):
    """
    Return Private Key password with support for OpenSSH-formatted
    private keys which don't support passwords over 72 bytes.
    """
    try:
        cid = cid.hex
    except AttributeError:
        cid = str(cid)

    # When bootstrapping consoles, lookup value in config file, in case
    # it's been generated just now as part of the initial setup process
    if not settings.PRIVATE_KEY_PASSWORD_PREFIX:
        settings.PRIVATE_KEY_PASSWORD_PREFIX = load_private_key('chacha')
        if not settings.PRIVATE_KEY_PASSWORD_PREFIX:
            return ''

    password = f'{settings.PRIVATE_KEY_PASSWORD_PREFIX}|{cid[::-1]}'.encode()

    if ssh and len(password) > 72:
        return password[-72:]

    return password


def long2intarr(long_int: int) -> List[int]:
    _bytes: List[int] = []
    while long_int:
        long_int, r = divmod(long_int, 256)
        _bytes.insert(0, r)
    return _bytes


def long_to_base64(n: int, mlen: int = 0) -> str:
    bys = long2intarr(n)
    if mlen:
        _len = mlen - len(bys)
        if _len:
            bys = [0] * _len + bys
    data = struct.pack("%sB" % len(bys), *bys)
    if not len(data):
        data = b"\x00"
    s = base64.urlsafe_b64encode(data).rstrip(b"=")
    return s.decode("ascii")
