from typing import NamedTuple, TypedDict, TYPE_CHECKING

if TYPE_CHECKING:
    from django.contrib.auth import get_user_model
    from signed_jwt_auth.tokens import Token, UntrustedToken
    User = get_user_model()


class ClaimCreds(TypedDict):
    cid: str
    email: str
    username: str


class UntrustedAuth(NamedTuple):
    user: 'User'
    token: 'UntrustedToken'


class VerifiedAuth(NamedTuple):
    user: 'User'
    token: 'Token'
