# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings
from django.contrib.postgres.operations import CITextExtension
from django.utils import timezone
from console_base.models.fields import CanonicalIdField, LCDateTimeField, LCTextField, NameCITextField, UUID6Field
from console_base.models.fernet import EncryptedBinaryField
from ..fields import KeyField
from ..choices import STATUS
from ..models import validate_public_key
help_text = 'Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.'

class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        CITextExtension(),
        migrations.CreateModel(
            name="PublicKey",
            fields=[
                ('id', UUID6Field(serialize=False, primary_key=True, editable=False)),
                ('created', LCDateTimeField(default=timezone.now)),
                ('modified', LCDateTimeField(default=timezone.now)),
                ('cid', CanonicalIdField(db_index=True, unique=True, help_text=help_text)),
                ('is_active', models.BooleanField(default=True)),
                ('last_used_on', LCDateTimeField(blank=True, null=True, verbose_name="Last Used On")),
                ('revocation_date', LCDateTimeField(verbose_name="Revocation Date", null=True, blank=True)),
                ("key", KeyField(help_text="The user's RSA/Ed25519 public key", validators=[validate_public_key], verbose_name='Public Key')),
                ("private_key", EncryptedBinaryField(help_text="The user's RSA/Ed25519 private key", null=True, blank=True, verbose_name='Private Key')),
                ("name", NameCITextField(verbose_name='Name')),
                ("user", models.ForeignKey(to=settings.AUTH_USER_MODEL, related_name="public_keys", on_delete=models.CASCADE, verbose_name='User')),
                ("status", LCTextField(verbose_name='Status', choices=STATUS.choices, default=STATUS.active)),
            ],
            options={
                "verbose_name": "Public Key",
                "verbose_name_plural": "Public Keys",
            },
        ),

        migrations.CreateModel(
            name="JWKSEndpointTrust",
            fields=[
                ('id', UUID6Field(serialize=False, primary_key=True, editable=False)),
                ('created', LCDateTimeField(default=timezone.now)),
                ('modified', LCDateTimeField(default=timezone.now)),
                ('cid', CanonicalIdField(db_index=True, unique=True, help_text=help_text)),
                ('is_active', models.BooleanField(default=True)),
                ("jwks_url", models.URLField(help_text="e.g. https://dev-87evx9ru.auth0.com/.well-known/jwks.json", verbose_name="JSON Web Key Set (JWKS) URL")),
                ("user", models.OneToOneField(on_delete=models.CASCADE, related_name="jwks_endpoint", to=settings.AUTH_USER_MODEL, verbose_name="User")),
            ],
            options={
                "verbose_name": "JSON Web Key Set",
                "verbose_name_plural": "JSON Web Key Sets",
            },
        ),
        migrations.AddConstraint(
            model_name='publickey',
            constraint=models.UniqueConstraint(fields=('user', 'name'), name='unique_name_per_user'),
        ),
        migrations.AddConstraint(
            model_name='publickey',
            constraint=models.UniqueConstraint(fields=('key',), name='keys_must_be_unique'),
        ),
        migrations.AddConstraint(
            model_name='jwksendpointtrust',
            constraint=models.UniqueConstraint(fields=('user', 'jwks_url'), name='unique_endpoint_url_per_user'),
        ),
    ]
