from drf_spectacular.utils import extend_schema, extend_schema_view

from console_base.api.viewsets import LCModelViewSet

from signed_jwt_auth.models import (
    PublicKey,
    JWKSEndpointTrust,
)
from .filters import (
    PublicKeyFilter,
    JWKSEndpointTrustFilter,
)
from .serializers import (
    PublicKeySerializer,
    PublicKeyDataTables,
    JWKSEndpointTrustSerializer,
    JWKSEndpointTrustDataTables,
)
from ..authentication import SignedTokenByProvidedKey


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Public Keys'),
    retrieve=extend_schema(summary='Get a Public Key'),
    create=extend_schema(summary='Create a Public Key'),
    update=extend_schema(summary='Update a Public Key'),
    partial_update=extend_schema(summary='Partially Update a Public Key'),
    destroy=extend_schema(summary='Delete a Public Key'),
)
class PublicKeyViewSet(LCModelViewSet):
    queryset = PublicKey.objects
    serializer_class = PublicKeySerializer
    datatables_serializer = PublicKeyDataTables
    filterset_class = PublicKeyFilter

    def get_authenticators(self):
        """
        Support auth verified by provided public key.
        """
        authenticators = super().get_authenticators()
        authenticators.insert(0, SignedTokenByProvidedKey())
        return authenticators


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List JWK Endpoints'),
    retrieve=extend_schema(summary='Get a JWK Endpoint'),
    create=extend_schema(summary='Create a JWK Endpoint'),
    update=extend_schema(summary='Update a JWK Endpoint'),
    partial_update=extend_schema(summary='Partially Update a JWK Endpoint'),
    destroy=extend_schema(summary='Delete a JWK Endpoint'),
)
class JWKSEndpointTrustViewSet(LCModelViewSet):
    queryset = JWKSEndpointTrust.objects
    serializer_class = JWKSEndpointTrustSerializer
    datatables_serializer = JWKSEndpointTrustDataTables
    filterset_class = JWKSEndpointTrustFilter


__all__ = (
    'PublicKeyViewSet',
    'JWKSEndpointTrustViewSet',
)
