from django.contrib.auth import get_user_model

from console_base.api.serializers import (
    LCModelSerializer,
    LCHyperlinkedIdentityField,
    CanonicalIDField,
)

from signed_jwt_auth.models import (
    PublicKey,
    JWKSEndpointTrust,
)

BASE_READ_ONLY_FIELDS = (
    'pk',
    'url',
    'created',
    'modified',
)

User = get_user_model()


# ---------------------------------------------------------------------------
class PublicKeySerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-publickey-detail')
    user = CanonicalIDField(queryset=User.objects.all())

    class Meta:
        model = PublicKey
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'user',
            'name',
            'key',
            'status',
            'last_used_on',
            'revocation_date',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class PublicKeyDataTables(PublicKeySerializer):

    class Meta(PublicKeySerializer.Meta):
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'user',
            'name',
            'status',
            'last_used_on',
            'revocation_date',
        )


# ---------------------------------------------------------------------------
class JWKSEndpointTrustSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-jwksendpointtrust-detail')
    user = CanonicalIDField(queryset=User.objects.all())

    class Meta:
        model = JWKSEndpointTrust
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'user',
            'jwks_url',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class JWKSEndpointTrustDataTables(JWKSEndpointTrustSerializer):

    class Meta(JWKSEndpointTrustSerializer.Meta):
        fields = JWKSEndpointTrustSerializer.Meta.fields + ('row_pk',)


__all__ = (
    'PublicKeySerializer',
    'PublicKeyDataTables',
    'JWKSEndpointTrustSerializer',
    'JWKSEndpointTrustDataTables',
)
