from console_base.filters import (
    DateFilter,
    NameFilter,
)

from signed_jwt_auth.models import (
    PublicKey,
    JWKSEndpointTrust,
)


# ---------------------------------------------------------------------------
class PublicKeyFilter(NameFilter):

    class Meta(DateFilter.Meta):
        model = PublicKey


# ---------------------------------------------------------------------------
class JWKSEndpointTrustFilter(DateFilter):

    class Meta(DateFilter.Meta):
        model = JWKSEndpointTrust


__all__ = (
    'PublicKeyFilter',
    'JWKSEndpointTrustFilter',
)
