#!/usr/bin/python3

import re
import os

from setuptools import setup


# def read(*names, **kwargs):
#     return io.open(
#         join(dirname(__file__), *names),
#         encoding=kwargs.get('encoding', 'utf8')
#     ).read()


def get_packages(package):
    """
    Return root package and all sub-packages.
    """
    return [
        dirpath
        for dirpath, dirnames, filenames in os.walk(package)
        if os.path.exists(os.path.join(dirpath, "__init__.py"))
    ]


def get_package_data(package):
    """
    Return all files under the root package, that are not in a
    package themselves.
    """
    walk = [
        (dirpath.replace(package + os.sep, "", 1), filenames)
        for dirpath, dirnames, filenames in os.walk(package)
        if not os.path.exists(os.path.join(dirpath, "__init__.py"))
    ]

    filepaths = []
    for base, filenames in walk:
        filepaths.extend([os.path.join(base, filename) for filename in filenames])
    return {package: filepaths}


def get_version():
    with open("redwoodctl/__init__.py", "r") as f:
        line = f.readline()
        match = re.match(r"__version__ = \"([\d\.]+)\"", line)

        if not match:
            raise ImportError("Can't read the version of Redwood Ctl")

        version = match.group(1)
        return version


setup(
    name="redwoodctl",
    version=get_version(),
    license="SAP",
    description="Redwood CLI Control Center",
    # long_description='%s\n%s' % (
    #     re.compile('^.. start-badges.*^.. end-badges', re.M | re.S).sub('', read('README.md')),
    #     re.sub(':[a-z]+:`~?(.*?)`', r'``\1``', read('CHANGELOG.md'))
    # ),
    long_description_content_type="text/markdown",
    author="Dave Burkholder",
    author_email="dave@compassfoundation.io",
    url="https://code.compassfoundation.io/dave/redwoodctl",
    packages=get_packages("redwoodctl"),
    package_data=get_package_data("redwoodctl"),
    zip_safe=True,
    options={
        "bdist_rpm": {
            "pre_install": "pre_install.sh",
        },
    },
    classifiers=[
        "Intended Audience :: Developers",
        "License :: SAP",
        "Operating System :: Unix",
        "Operating System :: POSIX",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Topic :: Utilities",
    ],
    keywords=[
        "Security Appliance",
        "Redwood",
    ],
    install_requires=[
        "django",
        "lchttp",
        "invoke",
        "lcrequests",
        "maxminddb",
        "msgspec",
        "tabulate",
    ],
    entry_points={
        "console_scripts": [
            "classify = redwoodctl.classify.main:program.run",
            "rc = redwoodctl.main:program.run",
            "redwood-ctl = redwoodctl.main:program.run",
        ],
    },
)
