from enum import StrEnum
from msgspec import Struct
from typing import Literal

NUMBER = int | float


class RedwoodAction(StrEnum):
    Allow = "allow"
    Block = "block"
    Ignore = "ignore"
    ACL = "acl"


ACTIONS = Literal["allow", "block", "ignore", "acl"]
RULE_TYPES = Literal["domain", "ip", "phrase", "regex"]


class CategoryConf(Struct):
    """
    Category config with basic keys included.
    """

    id: str
    action: ACTIONS
    genre_id: str
    rating: str
    parent_multiplier: float = 1.0


CATEGORY_CONFIGS = dict[str, CategoryConf]
CATEGORY_NAMES_SCORES = dict[str, int]
RULE_NAMES_COUNT = dict[str, int]


class RuleStat(Struct):
    Count: int
    Score: int


class ClassifierRatings(StrEnum):
    """
    Ratings that are used for Classifier purposes.
    """

    SILT = "silt"
    SAND = "sand"
    PEBBLE = "pebble"
    STONE = "stone"
    ROCK = "rock"
    BOULDER = "boulder"


class RatingCode(StrEnum):
    MISC = "misc"
    BASE = "bse"
    SILT = "slt"
    SAND = "snd"
    PEBBLE = "pbs"
    STONE = "stn"
    ROCK = "rck"
    BOULDER = "bld"
    ADS = "ads"
    SLAG = "slag"


class RatingName(StrEnum):
    MISC = "misc"
    BASE = "base"
    SILT = "silt"
    SAND = "sand"
    PEBBLE = "pebble"
    STONE = "stone"
    ROCK = "rock"
    BOULDER = "boulder"
    ADS = "ads"
    SLAG = "slag"


NON_SCORING_RATINGS = (
    RatingName.MISC.value,
    RatingName.BASE.value,
    RatingName.ADS.value,
    RatingName.SLAG.value,
)


__all__ = (
    "RedwoodAction",
    "ACTIONS",
    "RULE_TYPES",
    "CategoryConf",
    "CATEGORY_CONFIGS",
    "CATEGORY_NAMES_SCORES",
    "RuleStat",
    "RULE_NAMES_COUNT",
    "ClassifierRatings",
    "RatingCode",
    "RatingName",
    "NON_SCORING_RATINGS",
    "NUMBER",
)
