domain_rules_only = {
    "rules": {
        "/./": 1,
        "/\\bbank/h": 1,
        "/bank\\b/h": 1,
        "/national-bank/": 1,
        "/national-bank/d": 1,
        "bank": 1,
    },
    "scoreAnalysis": {
        "finance": {
            "/bank\\b/h": {"Count": 1, "Score": 450},
            "bank": {"Count": 1, "Score": 300},
        },
        "lc_Cortana_block": {"/./": {"Count": 1, "Score": 1500}},
        "lc_matchallNone": {"/./": {"Count": 1, "Score": 1500}},
    },
}

domain_phrases = {
    "rules": {
        "/./": 1,
        "/\\.js$/p": 1,
        "/\\.js\\b/p": 1,
        "< ancestr>": 1,
        "< calendar>": 1,
        "< cream >": 1,
        "< fonts >": 2,
        "< ipad >": 4,
        "< kde >": 10,
        "< linux >": 5,
        "< macos >": 7,
        "<android app>": 1,
        "<blackberry>": 7,
        "<color scheme>": 1,
        "<for mac>": 2,
        "<for windows>": 2,
        "<generator>": 1,
        "<ginger>": 1,
        "<home accent>": 2,
        "<ice cream>": 1,
        "<ios app>": 1,
        "<keyboard shortcut>": 1,
        "<kindle fire>": 1,
        "<marshmallow>": 1,
        "<parser>": 1,
        "<playstation 4>": 3,
        "<playstation>": 3,
        "<radial>": 2,
        "<video playback>": 1,
        "<windows phone>": 4,
    },
    "scoreAnalysis": {
        "art": {
            "< fonts >": {"Count": 2, "Score": -20},
            "<home accent>": {"Count": 2, "Score": -40},
        },
        "auto": {
            "< calendar>": {"Count": 1, "Score": -25},
            "<radial>": {"Count": 2, "Score": 30},
        },
        "base_blanket_block": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "booksliterature": {
            "/\\.js\\b/p": {"Count": 1, "Score": -300},
            "<kindle fire>": {"Count": 1, "Score": 25},
        },
        "clothing": {"<color scheme>": {"Count": 1, "Score": -30}},
        "clothing_intimate": {"<color scheme>": {"Count": 1, "Score": -30}},
        "computer": {
            "< macos >": {"Count": 7, "Score": 175},
            "<android app>": {"Count": 1, "Score": 13},
            "<for mac>": {"Count": 2, "Score": 40},
            "<for windows>": {"Count": 2, "Score": -20},
            "<ios app>": {"Count": 1, "Score": 13},
            "<keyboard shortcut>": {"Count": 1, "Score": 10},
            "<parser>": {"Count": 1, "Score": 20},
        },
        "content_photosharing": {
            "/\\.js\\b/p": {"Count": 1, "Score": -300},
            "<video playback>": {"Count": 1, "Score": 20},
        },
        "content_television": {"/\\.js$/p": {"Count": 1, "Score": -500}},
        "education": {"<parser>": {"Count": 1, "Score": -20}},
        "energyelectrical": {"<generator>": {"Count": 1, "Score": 15}},
        "fashion": {"<color scheme>": {"Count": 1, "Score": -30}},
        "foods": {
            "< cream >": {"Count": 1, "Score": 20},
            "<ice cream>": {"Count": 1, "Score": 20},
        },
        "foods/beverages": {
            "< cream >": {"Count": 1, "Score": 20},
            "<ice cream>": {"Count": 1, "Score": 20},
        },
        "games": {
            "<playstation 4>": {"Count": 3, "Score": 105},
            "<playstation>": {"Count": 3, "Score": 60},
        },
        "genealogy": {"< ancestr>": {"Count": 1, "Score": 25}},
        "herbal": {
            "<ginger>": {"Count": 1, "Score": 10},
            "<marshmallow>": {"Count": 1, "Score": 10},
        },
        "interiordecorating": {"<home accent>": {"Count": 2, "Score": 50}},
        "isptelecom": {"<blackberry>": {"Count": 7, "Score": 119}},
        "lc_Apple_Configurator": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_CA_EmailAndUpdates": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_Cortana_block": {"/./": {"Count": 1, "Score": 1500}},
        "lc_Silver_ML_Default": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_Silver_ML_EmailandUpdates": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_email_only": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_epmc_emailandupdates_73": {
            "/\\.js$/p": {"Count": 1, "Score": 1500},
            "/\\.js\\b/p": {"Count": 1, "Score": 1500},
        },
        "lc_matchallNone": {"/./": {"Count": 1, "Score": 1500}},
        "mobiledevices": {
            "< ipad >": {"Count": 4, "Score": 80},
            "<windows phone>": {"Count": 4, "Score": 120},
        },
        "news/news_fashion": {"<color scheme>": {"Count": 1, "Score": -27}},
        "news/news_genealogy": {"< ancestr>": {"Count": 1, "Score": 22}},
        "os": {
            "< kde >": {"Count": 10, "Score": 300},
            "< linux >": {"Count": 5, "Score": 75},
        },
        "pageassets": {"/\\.js\\b/p": {"Count": 1, "Score": 400}},
        "pornography": {"/\\.js\\b/p": {"Count": 1, "Score": -499}},
        "powersports": {"< calendar>": {"Count": 1, "Score": -25}},
        "publishing": {"<color scheme>": {"Count": 1, "Score": 15}},
    },
}

reuters = {
    "rules": {
        "/./": 1,
        "/\\breuters.com\\/$/": 1,
        "< abortion>": 5,
        "< airlines>": 2,
        "< ambulance>": 1,
        "< assault>": 1,
        "< athletics>": 5,
        "< baseball >": 4,
        "< basketball>": 5,
        "< battery>": 2,
        "< bitcoin>": 9,
        "< calendar>": 1,
        "< carving>": 11,
        "< chairs >": 7,
        "< composer>": 3,
        "< dharma>": 1,
        "< drawing>": 2,
        "< etfs >": 2,
        "< football>": 1,
        "< games>": 8,
        "< golf >": 4,
        "< gop >": 1,
        "< id video>": 1,
        "< jet engine>": 1,
        "< jury>": 6,
        "< koran >": 1,
        "< litigation>": 9,
        "< low carb>": 8,
        "< low carbon>": 8,
        "< motorsport>": 2,
        "< muslim>": 1,
        "< my account>": 1,
        "< nvidia >": 35,
        "< parade >": 4,
        "< passionate >": 1,
        "< pasture>": 2,
        "< pharmac>": 3,
        "< playlist>": 29,
        "< police >": 15,
        "< politics>": 1,
        "< pool>": 6,
        "< president >": 41,
        "< psycholog>": 1,
        "< reuters>": 10728,
        "< rubens >": 1,
        "< salt >": 1,
        "< sex >": 2,
        "< soccer>": 13,
        "< socialist>": 9,
        "< soldier>": 7,
        "< soprano>": 4,
        "< sports >": 59,
        "< tennis>": 14,
        "< tent >": 10,
        "< tents>": 1,
        "< terroris>": 3,
        "< ticker>": 26,
        "< training>": 6,
        "< trans >": 4,
        "< truck>": 6,
        "<abortion >": 5,
        "<abortion>": 5,
        "<agriculture >": 4,
        "<air show>": 3,
        "<airport >": 4,
        "<airshow>": 1,
        "<aspect ratio>": 41,
        "<asset manag>": 1,
        "<asset management>": 1,
        "<attorney general>": 1,
        "<attorney>": 9,
        "<aviation>": 7,
        "<battalion>": 1,
        "<biodiversity>": 4,
        "<boeing>": 1,
        "<breaking news>": 5,
        "<business news>": 1,
        "<business website>": 2,
        "<carbon market>": 2,
        "<chair>": 7,
        "<clutch>": 1,
        "<coca cola>": 15,
        "<code base>": 1,
        "<composite index>": 2,
        "<conference>": 29,
        "<contract>": 9,
        "<cryptocurrenc>": 2,
        "<data type>": 1,
        "<dow jones>": 3,
        "<drawing>": 2,
        "<election campaign>": 1,
        "<election result>": 7,
        "<electric vehicle>": 4,
        "<energy drink>": 1,
        "<engine parts>": 1,
        "<first name>": 51,
        "<futures>": 5,
        "<gallo>": 2,
        "<gender>": 3,
        "<general motors>": 2,
        "<government website>": 1,
        "<hamas war>": 11,
        "<healthcare>": 5,
        "<home show>": 1,
        "<hospital >": 4,
        "<house of representatives>": 1,
        "<jet engine>": 1,
        "<kitchen>": 1,
        "<last name>": 51,
        "<latest news>": 7,
        "<legal form>": 8,
        "<livestock>": 5,
        "<logitech>": 12,
        "<military base>": 7,
        "<motor sport>": 3,
        "<nasdaq>": 5,
        "<national anthem>": 1,
        "<national committee>": 2,
        "<national news>": 14,
        "<news conference>": 7,
        "<news coverage>": 6,
        "<news stories>": 3,
        "<opera house>": 8,
        "<parliament >": 10,
        "<personal care>": 1,
        "<photojournalis>": 1,
        "<pickup >": 3,
        "<pickup truck>": 3,
        "<presidential election>": 8,
        "<press conference>": 1,
        "<promotions>": 2,
        "<react js>": 1,
        "<relationship>": 2,
        "<republican candida>": 1,
        "<republican national committee>": 2,
        "<river rock>": 10,
        "<s p 500>": 3,
        "<security council>": 7,
        "<sports news>": 3,
        "<stock exchange>": 9,
        "<story type>": 7,
        "<supply chain>": 2,
        "<supreme court>": 4,
        "<tax account>": 2,
        "<telecom>": 9,
        "<tesla>": 10,
        "<the city of>": 1,
        "<the state of>": 2,
        "<third party>": 60,
        "<top video>": 1,
        "<travel ban>": 3,
        "<united nations>": 4,
        "<university of >": 3,
        "<verizon>": 16,
        "<video ad >": 1,
        "<wireless carrier>": 2,
        "<worship>": 1,
        "reuters.com": 1,
    },
    "scoreAnalysis": {
        "ag": {
            "< motorsport>": {"Count": 2, "Score": -60},
            "< pasture>": {"Count": 2, "Score": 30},
            "<agriculture >": {"Count": 4, "Score": 120},
            "<gallo>": {"Count": 2, "Score": 40},
            "<livestock>": {"Count": 5, "Score": 150},
        },
        "airfare": {
            "< airlines>": {"Count": 2, "Score": 10},
            "< jet engine>": {"Count": 1, "Score": 25},
            "<airport >": {"Count": 4, "Score": 20},
            "<aviation>": {"Count": 7, "Score": 175},
            "<boeing>": {"Count": 1, "Score": 25},
        },
        "appliances": {"<clutch>": {"Count": 1, "Score": 5}},
        "art": {
            "< rubens >": {"Count": 1, "Score": 65},
            "<airport >": {"Count": 4, "Score": -100},
        },
        "auto": {
            "< calendar>": {"Count": 1, "Score": -25},
            "< golf >": {"Count": 4, "Score": 80},
            "< motorsport>": {"Count": 2, "Score": 60},
            "<electric vehicle>": {"Count": 4, "Score": 80},
            "<engine parts>": {"Count": 1, "Score": 20},
            "<general motors>": {"Count": 2, "Score": 50},
            "<jet engine>": {"Count": 1, "Score": 20},
            "<motor sport>": {"Count": 3, "Score": 90},
            "<pickup truck>": {"Count": 3, "Score": 60},
            "<tesla>": {"Count": 10, "Score": 199},
        },
        "booksliterature": {"< sex >": {"Count": 2, "Score": -70}},
        "computer": {
            "< games>": {"Count": 8, "Score": -80},
            "< nvidia >": {"Count": 35, "Score": 350},
            "<aspect ratio>": {"Count": 41, "Score": 120},
            "<asset management>": {"Count": 1, "Score": 20},
            "<code base>": {"Count": 1, "Score": 15},
            "<composite index>": {"Count": 2, "Score": 70},
            "<data type>": {"Count": 1, "Score": 20},
            "<logitech>": {"Count": 12, "Score": 240},
            "<react js>": {"Count": 1, "Score": 10},
        },
        "construction": {
            "<drawing>": {"Count": 2, "Score": 10},
            "<home show>": {"Count": 1, "Score": 15},
        },
        "content_movies": {
            "< id video>": {"Count": 1, "Score": 5},
            "<breaking news>": {"Count": 5, "Score": -125},
            "<latest news>": {"Count": 7, "Score": -105},
            "<national news>": {"Count": 14, "Score": -210},
            "<news coverage>": {"Count": 6, "Score": -90},
            "<news stories>": {"Count": 3, "Score": -45},
            "<personal care>": {"Count": 1, "Score": -10},
            "reuters.com": {"Count": 1, "Score": -500},
        },
        "content_music": {
            "< composer>": {"Count": 3, "Score": 105},
            "< playlist>": {"Count": 29, "Score": 160},
            "< soprano>": {"Count": 4, "Score": 80},
            "<opera house>": {"Count": 8, "Score": 280},
        },
        "coronavirus": {"<travel ban>": {"Count": 3, "Score": 90}},
        "crafts": {"<drawing>": {"Count": 2, "Score": 10}},
        "drugs_legal": {"<kitchen>": {"Count": 1, "Score": -10}},
        "drugs_legal/medicinal": {"<kitchen>": {"Count": 1, "Score": -10}},
        "education": {"<university of >": {"Count": 3, "Score": 45}},
        "emergencysvc": {"< ambulance>": {"Count": 1, "Score": 20}},
        "energyelectrical": {
            "< battery>": {"Count": 2, "Score": 20},
            "<carbon market>": {"Count": 2, "Score": 60},
        },
        "entertainmentvenues": {"< parade >": {"Count": 4, "Score": 100}},
        "event_rentals": {
            "< tent >": {"Count": 10, "Score": 30},
            "< tents>": {"Count": 1, "Score": 5},
            "<conference>": {"Count": 29, "Score": 50},
            "<third party>": {"Count": 60, "Score": -1500},
        },
        "finance": {
            "< etfs >": {"Count": 2, "Score": 30},
            "< my account>": {"Count": 1, "Score": 25},
            "< ticker>": {"Count": 26, "Score": 200},
            "<asset manag>": {"Count": 1, "Score": 25},
            "<business news>": {"Count": 1, "Score": 25},
            "<dow jones>": {"Count": 3, "Score": 75},
            "<futures>": {"Count": 5, "Score": 100},
            "<nasdaq>": {"Count": 5, "Score": 225},
            "<s p 500>": {"Count": 3, "Score": 75},
            "<stock exchange>": {"Count": 9, "Score": 225},
            "<supply chain>": {"Count": 2, "Score": 50},
        },
        "finance_alternate": {
            "< bitcoin>": {"Count": 9, "Score": 180},
            "<cryptocurrenc>": {"Count": 2, "Score": 50},
        },
        "fitness/bodybuilding": {"< truck>": {"Count": 6, "Score": -90}},
        "foods": {
            "< low carb>": {"Count": 8, "Score": 40},
            "< low carbon>": {"Count": 8, "Score": -80},
            "< salt >": {"Count": 1, "Score": 10},
            "<relationship>": {"Count": 2, "Score": -20},
        },
        "foods/beverages": {
            "< low carb>": {"Count": 8, "Score": 40},
            "< low carbon>": {"Count": 8, "Score": -80},
            "< salt >": {"Count": 1, "Score": 10},
            "<coca cola>": {"Count": 15, "Score": 525},
            "<energy drink>": {"Count": 1, "Score": 35},
            "<relationship>": {"Count": 2, "Score": -20},
        },
        "games": {
            "< games>": {"Count": 8, "Score": 120},
            "<business news>": {"Count": 1, "Score": -25},
            "<personal care>": {"Count": 1, "Score": -10},
        },
        "golf": {"< golf >": {"Count": 4, "Score": 80}},
        "isptelecom": {
            "<telecom>": {"Count": 9, "Score": 243},
            "<verizon>": {"Count": 16, "Score": 400},
            "<wireless carrier>": {"Count": 2, "Score": 50},
        },
        "lawn": {"<river rock>": {"Count": 10, "Score": 250}},
        "lc_Cortana_block": {"/./": {"Count": 1, "Score": 1500}},
        "lc_matchallNone": {"/./": {"Count": 1, "Score": 1500}},
        "legal": {
            "< jury>": {"Count": 6, "Score": 120},
            "< litigation>": {"Count": 9, "Score": 180},
            "<attorney>": {"Count": 9, "Score": 180},
            "<contract>": {"Count": 9, "Score": 45},
            "<legal form>": {"Count": 8, "Score": 200},
        },
        "medical_general": {
            "<healthcare>": {"Count": 5, "Score": 50},
            "<hospital >": {"Count": 4, "Score": 100},
        },
        "medical_psychiatry": {"< psycholog>": {"Count": 1, "Score": 20}},
        "medical_reproduction": {"<abortion>": {"Count": 5, "Score": 175}},
        "metals": {"< drawing>": {"Count": 2, "Score": 10}},
        "military": {
            "< soldier>": {"Count": 7, "Score": 140},
            "< terroris>": {"Count": 3, "Score": 60},
            "<battalion>": {"Count": 1, "Score": 40},
            "<hamas war>": {"Count": 11, "Score": 440},
            "<military base>": {"Count": 7, "Score": 245},
        },
        "news": {
            "< politics>": {"Count": 1, "Score": 25},
            "< reuters>": {"Count": 10728, "Score": 190},
            "<breaking news>": {"Count": 5, "Score": 125},
            "<latest news>": {"Count": 7, "Score": 175},
            "<national news>": {"Count": 14, "Score": 350},
            "<news conference>": {"Count": 7, "Score": 189},
            "<news coverage>": {"Count": 6, "Score": 150},
            "<news stories>": {"Count": 3, "Score": 45},
        },
        "news/news_celebrity": {
            "< politics>": {"Count": 1, "Score": 20},
            "< reuters>": {"Count": 10728, "Score": 152},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<latest news>": {"Count": 7, "Score": 140},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
        },
        "news/news_fashion": {
            "< politics>": {"Count": 1, "Score": 20},
            "< reuters>": {"Count": 10728, "Score": 152},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<latest news>": {"Count": 7, "Score": 140},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
        },
        "news/news_genealogy": {
            "< politics>": {"Count": 1, "Score": 18},
            "< reuters>": {"Count": 10728, "Score": 142},
            "<breaking news>": {"Count": 5, "Score": 90},
            "<latest news>": {"Count": 7, "Score": 126},
            "<national news>": {"Count": 14, "Score": 252},
            "<news conference>": {"Count": 7, "Score": 140},
            "<news coverage>": {"Count": 6, "Score": 108},
            "<news stories>": {"Count": 3, "Score": 33},
        },
        "news/news_humor": {
            "< politics>": {"Count": 1, "Score": 17},
            "< reuters>": {"Count": 10728, "Score": 133},
            "<breaking news>": {"Count": 5, "Score": 85},
            "<latest news>": {"Count": 7, "Score": 119},
            "<national news>": {"Count": 14, "Score": 238},
            "<news conference>": {"Count": 7, "Score": 126},
            "<news coverage>": {"Count": 6, "Score": 102},
            "<news stories>": {"Count": 3, "Score": 30},
        },
        "news/news_medical": {
            "< politics>": {"Count": 1, "Score": 16},
            "< reuters>": {"Count": 10728, "Score": 123},
            "<breaking news>": {"Count": 5, "Score": 80},
            "<healthcare>": {"Count": 5, "Score": 45},
            "<hospital >": {"Count": 4, "Score": 88},
            "<latest news>": {"Count": 7, "Score": 112},
            "<national news>": {"Count": 14, "Score": 224},
            "<news conference>": {"Count": 7, "Score": 119},
            "<news coverage>": {"Count": 6, "Score": 96},
            "<news stories>": {"Count": 3, "Score": 27},
        },
        "news/news_military": {
            "< politics>": {"Count": 1, "Score": 20},
            "< reuters>": {"Count": 10728, "Score": 152},
            "< soldier>": {"Count": 7, "Score": 126},
            "< terroris>": {"Count": 3, "Score": 54},
            "<battalion>": {"Count": 1, "Score": 36},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<hamas war>": {"Count": 11, "Score": 396},
            "<latest news>": {"Count": 7, "Score": 140},
            "<military base>": {"Count": 7, "Score": 217},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
        },
        "news/news_politics": {
            "< gop >": {"Count": 1, "Score": 27},
            "< politics>": {"Count": 1, "Score": 20},
            "< reuters>": {"Count": 10728, "Score": 152},
            "< socialist>": {"Count": 9, "Score": 117},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<election campaign>": {"Count": 1, "Score": 27},
            "<election result>": {"Count": 7, "Score": 162},
            "<house of representatives>": {"Count": 1, "Score": 27},
            "<latest news>": {"Count": 7, "Score": 140},
            "<national committee>": {"Count": 2, "Score": 18},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
            "<parliament >": {"Count": 10, "Score": 90},
            "<presidential election>": {"Count": 8, "Score": 216},
            "<press conference>": {"Count": 1, "Score": 27},
            "<republican candida>": {"Count": 1, "Score": 27},
            "<republican national committee>": {"Count": 2, "Score": 54},
            "<security council>": {"Count": 7, "Score": 189},
            "<supreme court>": {"Count": 4, "Score": 90},
            "<united nations>": {"Count": 4, "Score": 108},
        },
        "news/news_sports": {
            "< athletics>": {"Count": 5, "Score": 135},
            "< baseball >": {"Count": 4, "Score": 88},
            "< basketball>": {"Count": 5, "Score": 27},
            "< football>": {"Count": 1, "Score": 22},
            "< politics>": {"Count": 1, "Score": -22},
            "< reuters>": {"Count": 10728, "Score": 152},
            "< soccer>": {"Count": 13, "Score": 171},
            "< tennis>": {"Count": 14, "Score": 162},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<latest news>": {"Count": 7, "Score": 140},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
            "<sports news>": {"Count": 3, "Score": 81},
            "reuters.com": {"Count": 1, "Score": -500},
        },
        "news/news_weapons": {
            "< politics>": {"Count": 1, "Score": 20},
            "< reuters>": {"Count": 10728, "Score": 152},
            "<breaking news>": {"Count": 5, "Score": 100},
            "<latest news>": {"Count": 7, "Score": 140},
            "<national news>": {"Count": 14, "Score": 280},
            "<news conference>": {"Count": 7, "Score": 147},
            "<news coverage>": {"Count": 6, "Score": 120},
            "<news stories>": {"Count": 3, "Score": 36},
        },
        "news_business": {"<business news>": {"Count": 1, "Score": 25}},
        "news_cbc": {
            "< abortion>": {"Count": 5, "Score": -175},
            "< assault>": {"Count": 1, "Score": -35},
            "< sex >": {"Count": 2, "Score": -70},
            "< trans >": {"Count": 4, "Score": -140},
        },
        "pageassets": {
            "<first name>": {"Count": 51, "Score": 30},
            "<gender>": {"Count": 3, "Score": 20},
            "<last name>": {"Count": 51, "Score": 30},
        },
        "pharmacy": {"< pharmac>": {"Count": 3, "Score": 60}},
        "photography": {"<photojournalis>": {"Count": 1, "Score": 55}},
        "politics": {
            "< gop >": {"Count": 1, "Score": 30},
            "< socialist>": {"Count": 9, "Score": 135},
            "<election campaign>": {"Count": 1, "Score": 30},
            "<election result>": {"Count": 7, "Score": 180},
            "<house of representatives>": {"Count": 1, "Score": 30},
            "<national committee>": {"Count": 2, "Score": 20},
            "<parliament >": {"Count": 10, "Score": 100},
            "<presidential election>": {"Count": 8, "Score": 240},
            "<press conference>": {"Count": 1, "Score": 30},
            "<republican candida>": {"Count": 1, "Score": 30},
            "<republican national committee>": {"Count": 2, "Score": 60},
            "<security council>": {"Count": 7, "Score": 210},
            "<supreme court>": {"Count": 4, "Score": 100},
            "<united nations>": {"Count": 4, "Score": 120},
        },
        "pornography": {"< sex >": {"Count": 2, "Score": 50}},
        "powersports": {
            "< calendar>": {"Count": 1, "Score": -25},
            "<engine parts>": {"Count": 1, "Score": 19},
        },
        "promotional": {"<promotions>": {"Count": 2, "Score": 10}},
        "publishing": {"<business website>": {"Count": 2, "Score": 40}},
        "racing": {
            "< battery>": {"Count": 2, "Score": -40},
            "< motorsport>": {"Count": 2, "Score": 60},
            "<motor sport>": {"Count": 3, "Score": 90},
        },
        "religion_anabaptist": {
            "< politics>": {"Count": 1, "Score": -15},
            "< sports >": {"Count": 59, "Score": -2065},
            "<worship>": {"Count": 1, "Score": 25},
        },
        "religion_eastern": {
            "< dharma>": {"Count": 1, "Score": 35},
            "< koran >": {"Count": 1, "Score": 35},
            "< muslim>": {"Count": 1, "Score": 35},
        },
        "sexeducation": {"< passionate >": {"Count": 1, "Score": 20}},
        "shipping": {
            "<pickup >": {"Count": 3, "Score": 15},
            "<supply chain>": {"Count": 2, "Score": 50},
        },
        "state_sites": {
            "<attorney general>": {"Count": 1, "Score": 15},
            "<government website>": {"Count": 1, "Score": 35},
            "<supreme court>": {"Count": 4, "Score": 108},
            "<tax account>": {"Count": 2, "Score": 70},
            "<the city of>": {"Count": 1, "Score": 190},
            "<the state of>": {"Count": 2, "Score": 70},
            "<university of >": {"Count": 3, "Score": 45},
        },
        "swimming": {
            "< pool>": {"Count": 6, "Score": 15},
            "<chair>": {"Count": 7, "Score": 15},
            "<engine parts>": {"Count": 1, "Score": -20},
        },
        "training": {"< training>": {"Count": 6, "Score": 54}},
        "training/safety": {"< training>": {"Count": 6, "Score": 54}},
        "travel_countryprofiles": {
            "< composer>": {"Count": 3, "Score": 60},
            "<biodiversity>": {"Count": 4, "Score": 80},
            "<national anthem>": {"Count": 1, "Score": 20},
            "<presidential election>": {"Count": 8, "Score": 160},
        },
        "travel_recreation": {
            "<air show>": {"Count": 3, "Score": 75},
            "<airshow>": {"Count": 1, "Score": 25},
        },
        "travel_utility": {
            "< airlines>": {"Count": 2, "Score": 6},
            "< basketball>": {"Count": 5, "Score": 120},
            "< tennis>": {"Count": 14, "Score": 175},
            "<airport >": {"Count": 4, "Score": 8},
            "<travel ban>": {"Count": 3, "Score": 75},
        },
        "veterinary": {"<abortion >": {"Count": 5, "Score": 125}},
        "weather": {
            "< police >": {"Count": 15, "Score": -150},
            "< president >": {"Count": 41, "Score": -410},
            "< sports >": {"Count": 59, "Score": -150},
            "<breaking news>": {"Count": 5, "Score": -125},
            "<national news>": {"Count": 14, "Score": -210},
            "<story type>": {"Count": 7, "Score": -105},
            "<top video>": {"Count": 1, "Score": -15},
        },
        "webmarketing": {"<video ad >": {"Count": 1, "Score": 23}},
        "woodworking": {
            "< carving>": {"Count": 11, "Score": 330},
            "< chairs >": {"Count": 7, "Score": 105},
        },
    },
}
