import csv
from typing import Any, Sequence


def line_to_dict(line: str, csv_fields: Sequence[str]) -> dict[str, Any] | None:
    try:
        return csv.DictReader(line.splitlines(True), csv_fields).__next__()
    except StopIteration:
        print("No more lines left")
