from invoke.context import Context
from invoke.tasks import task
import socket


@task
def status(ctx: Context) -> None:  # noqa
    """
    Check Redwood status
    """
    port = 6502
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect(("localhost", port))
    except Exception:
        print(f"DISASTER! Redwood server is not running or responding on {port}")
    finally:
        s.close()


@task
def restart(ctx: Context) -> None:  # noqa
    """Restart the Redwood Process"""
    ctx.sudo("service restart redwood", pty=True)


__all__ = (
    "restart",
    "status",
)
