from invoke.context import Context
from invoke.tasks import task
from lchttp import HTMLParser
from redwoodctl.http import download_page


@task
def sections(ctx: Context, url: str) -> None:
    """
    Download Page and parse into sections of interest.
    """
    header = """
# ---------------------------------------------------------
# {section} {name}
# ---------------------------------------------------------
    """
    response = download_page(url)
    hp = HTMLParser(response.text)

    print(header.format(section="URL:", name=url))
    print(header.format(section="Page Title:", name=hp.title()))
    print(header.format(section="Keywords & Tags", name=""))
    for kw in hp.keywords():
        print(kw)

    print(header.format(section="Asset Domains", name=""))
    for domain in hp.asset_domains():
        print(domain)

    print(header.format(section="External Domains", name=""))
    for domain in hp.external_domains():
        print(domain)


__all__ = [
    "sections",
]
