from invoke.context import Context
from invoke.tasks import task
from lcconfig import ConsoleSettingsConfig
from ..settings import REDWOOD_LOG_FIELDS
from .utils import line_to_dict


@task(help={"logline": "Redwood access log line from access.log"})
def columns(ctx: Context, logline: str) -> None:  # noqa
    """
    Print out columns of Redwood Log file
    """
    ll = line_to_dict(logline, REDWOOD_LOG_FIELDS)
    if not ll:
        return

    for column, value in ll.items():
        print(f"\n{column}:  {value}")

    rule_description = ll.get("rule_description")
    if rule_description:
        cfg = ConsoleSettingsConfig().as_typed_dict("BoxData")
        adminurl = cfg["adminurl"]
        external_port = cfg["external_port"]

        prefix, pk = rule_description.split("/")
        url = f"{adminurl}:{external_port}" if external_port != 443 else adminurl

        if prefix == "AP":
            print(f"\nAccess Policy URL: https://{url}/console/accesspolicy/detail/{pk}/\n")

    print()
