# mypy: disable-error-code="arg-type"
from invoke.collection import Collection
from . import auth
from . import logs
from . import sys

ns = Collection()
ns.add_collection(auth)
ns.add_collection(logs)
ns.add_collection(sys)

try:
    from . import page

    ns.add_collection(page)
except (ImportError, ModuleNotFoundError):
    pass

# Add as tasks so that we can run them without
# specifying a namespace
ns.add_task(logs.columns)
ns.add_task(sys.restart)
ns.add_task(sys.status)
