from invoke import Program
from invoke.collection import Collection
from invoke.config import Config, merge_dicts
from . import tasks
from . import __version__


class RedwoodConfig(Config):
    prefix = "redwood"

    @staticmethod
    def global_defaults():
        their_defaults = Config.global_defaults()
        my_defaults = {
            "run": {
                "echo": True,
            },
        }
        return merge_dicts(their_defaults, my_defaults)


program = Program(
    version=__version__,
    config_class=RedwoodConfig,
    namespace=Collection.from_module(tasks),
)
