from lcrequests import LogCabinHttpSession, Response


def download_page(url: str, verify_html: bool = True) -> Response:
    if not url.startswith("http"):
        url = f"http://{url}"

    try:
        request = LogCabinHttpSession(url)
        response = request.get()
        if response.status_code != 200:
            raise SystemExit(f"Unable to retrieve URL. Status code {response.status_code}")
        if verify_html:
            content_type = response.headers.get("Content-Type", "")
            if "/html" not in content_type:
                raise SystemExit(f"URL was not an HTML page - Content Type: {content_type!r}")
        return response
    except Exception as e:
        print(e)
        raise SystemExit(f"An error occurred; Unable to retrieve {url}")


__all__ = [
    "download_page",
]
