from typing import NamedTuple

from .redwood import classify_analyze_url
from ..typehints.redwood_api_types import ApiError
from ..typehints import (
    CATEGORY_CONFIGS,
    ClassifyUrlAnalyzedResponse,
)
from redwoodctl.redwood.analysis import (
    AutofixAnalysis,
    CategoryAnalysis,
    CombinedRatingAnalysis,
)


class AutofixResponse(NamedTuple):
    response: ApiError | ClassifyUrlAnalyzedResponse
    analysis: AutofixAnalysis | None


def classify_autofix_url(
    url: str,
    category_configs: CATEGORY_CONFIGS | None = None,
) -> AutofixResponse:
    """
    Classify URL to determine autofix level.
    """
    response = classify_analyze_url(url, category_configs)
    if isinstance(response, ApiError):
        return AutofixResponse(response, None)

    analysis = AutofixAnalysis(
        categories=CategoryAnalysis(response.classifierAnalysis),
        ratings=CombinedRatingAnalysis(response.ratings),
    )

    return AutofixResponse(response, analysis)


__all__ = (
    "classify_autofix_url",
    "AutofixResponse",
)
