#!/usr/bin/env python3
import io
import os
import re

from setuptools import setup, find_packages


def get_version():
    with open('pypowerdnsadmin/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of pypowerdns")

        version = match.group(1)
        return version


here = os.path.abspath(os.path.dirname(__file__))
with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = '\n' + f.read()

setup(
    name='pypowerdns',
    version=get_version(),
    description="PowerDNS Amdin API Client",
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    packages=find_packages(exclude=["tests"]),
    package_dir={'': '.'},
    license='MIT',
    zip_safe=True,
    url='https://code.compassfoundation.io/dave/pypowerdns',
    include_package_data=True,
    install_requires=[
        'lcrequests',
    ],
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: Implementation :: CPython',
    ],
)
