from lcrequests.exceptions import (
    LCHTTPError,
    AuthenticationError,
    AuthorizationError,
    ClientError,
    ServerError,
)


class PowerDNSError(LCHTTPError):
    """A generic error while attempting to communicate with PowerDNS"""


class PowerDNSServerError(ServerError):
    """The PowerDNS Server encountered an error while processing the request"""


class PowerDNSAuthenticationError(AuthenticationError):
    """Invalid authentication credentials"""


class PowerDNSAuthorizationError(AuthorizationError):
    """Invalid permission levels"""


class PowerDNSClientError(ClientError):
    """An invalid request has been made"""


__all__ = [
    'PowerDNSError',
    'PowerDNSServerError',
    'PowerDNSAuthenticationError',
    'PowerDNSAuthenticationError',
    'PowerDNSClientError',
]
