# pyPowerDNSAdmin

This is a Python library for communicating with PowerDNS Admin API.

The PowerDNS Admin API has various endpoints and not all of them are supported in this wrapper.
However the library has `http_get`, `http_post` and `http_delete` functions that  accept 
arbitrary URLs.

## Install

Install by cloning the repo and run `setup.py`.

```bash
$ python3 setup.py install
```

## Usage

To initialize do the following.

```python
from pypowerdnsadmin import PowerDNS
powerdns = PowerDNS('key', 'https://dns.example.com/api/v1')

# Here are some examples on what you can do with the generic built-in functions.
# You can request a Pro API endpoint by adding the `uapi=True` param to your function calls.
powerdns.http_get(url)
powerdns.http_post(url, post_data=data)
powerdns.http_patch(url, post_data=data)
powerdns.http_delete(url)

# List of Zones
powerdns.zones.list()

# Add a new DNS entry to a zone
from datetime import datetime
zone_struct = {
    'rrsets': [
        {
            'changetype': 'REPLACE', 
            'ttl': 300, 
            'type': 'A',
            'comments': [{'account': '<name>', 'content': 'Useful comments', 'modified_at': int(datetime.utcnow().timestamp())}], 
            'name': '<systemname>.example.tld.', 
            'records': [{'content': '5.4.3.2', 'disabled': False, 'set-ptr': False}], 
        },
    ],
}
resp = pdns.zones.update('example.tld', zone_struct)

# List of Servers
powerdns.servers.list()

```
