import httpretty
import json
import unittest
from pylogcabin import LogCabinAPI
from pylogcabin.tests.fixtures import *


class TestLogCabinAPI(unittest.TestCase):
    def setUp(self):
        httpretty.enable()

    def tearDown(self):
        httpretty.disable()
        httpretty.reset()

    def test_url_string(self):
        """
        URL string should update when load is called
        """
        app_models = (
            ('accounts', 'company'),
            ('accounts', 'policy'),
            ('latchstring', 'user'),
            ('devicedetector', 'operatingsystem'),
            ('devicedetector', 'application'),
        )
        lc = LogCabinAPI(server=API_SERVER, token='token')

        for app, model in app_models:
            lc.load(app=app, model=model)
            self.assertEqual(
                lc.url, '{url}/api/{app}/{model}'.format(url=API_SERVER, app=app, model=model)
            )

    def test_get(self):
        httpretty.register_uri(
            method=httpretty.GET,
            uri='{url}/api/accounts/company/{cid}/'.format(url=API_SERVER, cid=company1['cid']),
            body=json.dumps(company1),
            content_type='application/json',
        )

        lc = LogCabinAPI(server=API_SERVER, token='token')
        lc.load('accounts', 'company')
        response = lc.get(cid=company1['cid'])

        self.assertDictEqual(company1, response.json())
