from lcrequests.tokens import V4PasetoToken
from lcrequests.typehints import Subject
from lcrequests.umbrella import (
    ASPEN,
    BEACON,
    CENTRAL,
    CLAVIS,
    DRAWBRIDGE,
    VISION_MARKET,
)


# ---------------------------------------------------------------------------
class AspenPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Aspen CA Server.
    """
    subject = Subject.Aspen
    user_cid = ASPEN.cid


# ---------------------------------------------------------------------------
class BeaconPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Beacon MDM Server.
    """
    subject = Subject.Beacon
    user_cid = BEACON.cid


# ---------------------------------------------------------------------------
class ClavisPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Clavis SSO Server.
    """
    subject = Subject.Clavis
    user_cid = CLAVIS.cid


# ---------------------------------------------------------------------------
class DrawBridgePortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from DrawBridge Portals.
    """
    subject = Subject.DrawBridge
    user_cid = DRAWBRIDGE.cid


# ---------------------------------------------------------------------------
class VisionMarketToken(V4PasetoToken):
    """
    Token class to use for communications originating from Vision Market Portals.
    """
    subject = Subject.VisionMarket
    user_cid = VISION_MARKET.cid


# ---------------------------------------------------------------------------
class UmbrellaTokenCentral(V4PasetoToken):
    """
    Token class to use for communications from clients to Odoo Umbrella Central.
    """
    subject = Subject.Umbrella
    user_cid = CENTRAL.cid
