from lcrequests.tokens import V4PasetoToken as V4PasetoTokenBase
from lcrequests.typehints import Subject
from lcrequests.umbrella import (
    ASPEN,
    BEACON,
    CENTRAL,
    CLAVIS,
    DRAWBRIDGE,
    VISION_MARKET,
)


# ---------------------------------------------------------------------------
class V4PasetoToken(V4PasetoTokenBase):

    def __init__(self, *args, **kwargs):
        if 'user_cid' not in kwargs:
            kwargs['user_cid'] = self.user_cid
        super().__init__(*args, **kwargs)


# ---------------------------------------------------------------------------
class AspenPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Aspen CA Server.
    """
    subject = Subject.Aspen
    user_cid = ASPEN.cid


# ---------------------------------------------------------------------------
class BeaconPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Beacon MDM Server.
    """
    subject = Subject.Beacon
    user_cid = BEACON.cid


# ---------------------------------------------------------------------------
class ClavisPortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from Clavis SSO Server.
    """
    subject = Subject.Clavis
    user_cid = CLAVIS.cid


# ---------------------------------------------------------------------------
class DrawBridgePortalToken(V4PasetoToken):
    """
    Token class to use for communications originating from DrawBridge Portals.
    """
    subject = Subject.DrawBridge
    user_cid = DRAWBRIDGE.cid


# ---------------------------------------------------------------------------
class VisionMarketToken(V4PasetoToken):
    """
    Token class to use for communications originating from Vision Market Portals.
    """
    subject = Subject.VisionMarket
    user_cid = VISION_MARKET.cid


# ---------------------------------------------------------------------------
class UmbrellaTokenCentral(V4PasetoToken):
    """
    Token class to use for communications from clients to Odoo Umbrella Central.
    """
    subject = Subject.Umbrella
    user_cid = CENTRAL.cid
