from lcrequests.tokens import V4PasetoToken
from lcrequests.typehints import Subject
from lcrequests.umbrella import CENTRAL, DRAWBRIDGE


# ---------------------------------------------------------------------------
class AspenPortalToken(V4PasetoToken):
    """
    Token class to use for communications to Aspen CA Server.
    """
    subject = Subject.Aspen


# ---------------------------------------------------------------------------
class BeaconPortalToken(V4PasetoToken):
    """
    Token class to use for communications to Beacon MDM Server.
    """
    subject = Subject.Beacon


# ---------------------------------------------------------------------------
class ClavisPortalToken(V4PasetoToken):
    """
    Token class to use for communications to Clavis SSO Server.
    """
    subject = Subject.Clavis


# ---------------------------------------------------------------------------
class DrawBridgePortalToken(V4PasetoToken):
    """
    Token class to use for communications to DrawBridge Portals.
    """
    subject = Subject.DrawBridge


# ---------------------------------------------------------------------------
class VisionMarketToken(V4PasetoToken):
    """
    Token class to use for communications to Vision Market Portals.
    """
    subject = Subject.VisionMarket


# ---------------------------------------------------------------------------
class UmbrellaTokenDefault(V4PasetoToken):
    """
    Token class to use for communications from clients to Odoo Umbrella Central.
    """
    subject = Subject.Umbrella
    user_cid = CENTRAL.cid

    def __init__(self, *args, **kwargs):
        if 'user_cid' not in kwargs:
            kwargs['user_cid'] = self.user_cid
        super().__init__(*args, **kwargs)


# ---------------------------------------------------------------------------
class UmbrellaTokenDrawBridge(UmbrellaTokenDefault):
    user_cid = DRAWBRIDGE.cid
