from lcrequests.exceptions import LCHTTPError


class ConsoleAPIError(LCHTTPError):
    """A generic error while attempting to communicate with Log Cabin Console"""


class ConsoleAPIServerError(ConsoleAPIError):
    """The Console API encountered an error while processing the request"""


class ConsoleAPIAuthenticationError(ConsoleAPIError):
    """Invalid authentication credentials"""


class ConsoleAPIAuthorizationError(ConsoleAPIError):
    """Credentials have inadequate authorization to perform operation"""


class ConsoleAPIClientError(ConsoleAPIError):
    """An invalid request has been made"""


class ConsoleAPINotFoundError(ConsoleAPIError):
    """404 - Resource does not exist"""


__all__ = (
    'ConsoleAPIAuthenticationError',
    'ConsoleAPIAuthorizationError',
    'ConsoleAPIClientError',
    'ConsoleAPIError',
    'ConsoleAPIServerError',
    'ConsoleAPINotFoundError',
)
