class Create:

    def create(self, data, params=None, **kwargs):
        """
        Create a new record.

        :param data: Data to send to the server to create the resource
        :param params: Data to send as query parameters
        :param kwargs: Extra options to send to the server
        :return: dictionary of record
        """
        path = kwargs.pop('path', None) or f'{self.path}/id/0'
        return self.jamf.http_post(path, post_data=data, params=params, **kwargs)


class Get:

    def get(self, oid, params=None, **kwargs):
        """
        Get a single record

        :param oid: ID, such as serial number, udid or numerical ID
        :param params: Data to send as query parameters
        :param kwargs: Extra options to send to the server
        :return: dictionary of record
        """
        path = kwargs.pop('path', None) or f'{self.path}/id/{oid}'
        return self.jamf.http_get(path, params=params, **kwargs)


class List:

    def list(self, params=None, **kwargs):
        """
        Get list of all record.

        :param params: Data to send as query parameters
        :param kwargs: Extra options to send to the server
        :return: list of record dictionaries
        """
        path = kwargs.pop('path', None) or self.path
        return self.jamf.http_get(path, params=params, **kwargs)


class Update:

    def update(self, oid, data, params=None, **kwargs):
        """
        Update a single record

        :param data: Data to send to the server to create the resource
        :param oid: ID, such as serial number, udid or numerical ID
        :param params: Data to send as query parameters
        :param kwargs: Extra options to send to the server
        :return: dictionary of record
        """
        path = kwargs.pop('path', None) or f'{self.path}/id/{oid}'
        return self.jamf.http_put(path, params=params, post_data=data, **kwargs)


class Delete:

    def delete(self, oid, **kwargs):
        """
        Delete the record

        :param oid: ID, such as serial number, udid or numerical ID
        """
        path = f'{self.path}/id/{oid}'
        return self.jamf.http_delete(path, **kwargs)


class CRUD(Create, Get, List, Update, Delete):
    pass


class Read(Get, List):
    pass
