from lcrequests.exceptions import (
    LCHTTPError,
    AuthenticationError,
    AuthorizationError,
    ClientError,
    ServerError,
)


class JamfError(LCHTTPError):
    """A generic error while attempting to communicate with Jamf"""


class JamfServerError(ServerError):
    """The Jamf Server encountered an error while processing the request"""


class JamfAuthenticationError(AuthenticationError):
    """Invalid authentication credentials"""


class JamfAuthorizationError(AuthorizationError):
    """Invalid permission levels"""


class JamfClientError(ClientError):
    """An invalid request has been made"""


__all__ = [
    'JamfError',
    'JamfServerError',
    'JamfAuthenticationError',
    'JamfAuthenticationError',
    'JamfClientError',
]
