from .mixins import CRUD


class JamfRecord:
    """
    Base class for CRUD operations on Jamf Records.

    Subclasses class must define `path`.

    path: Base URL path on which requests will be sent (e.g. 'uapi/devices')
    """
    path = None

    def __init__(self, jamf):
        """
        :param jamf: `jamf.Jamf` connection to make requests
        """
        self.jamf = jamf


class Apps(CRUD, JamfRecord):
    path = 'JSSResource/mobiledeviceapplications'


class Buildings(CRUD, JamfRecord):
    path = 'JSSResource/buildings'


class Devices(CRUD, JamfRecord):
    path = 'JSSResource/mobiledevices'


class Profiles(CRUD, JamfRecord):
    path = 'JSSResource/mobiledeviceconfigurationprofiles'


class DeviceGroups(CRUD, JamfRecord):
    path = 'JSSResource/mobiledevicegroups'


class Users(CRUD, JamfRecord):
    path = 'JSSResource/users'
