# pyJamf

This is a Python library for communicating with Jamf MDM via their Jamf Classic/Pro REST API.

The API has various endpoints and not all of them are implemented with functions.
However the library has `http_get`, `http_post` and `http_delete` functions that
accept arbitrary URLs.

Consult the Jamf [Classic](https://crabapple.orbitmobile.io:8443/classicapi/doc/) /
[Pro](https://crabapple.orbitmobile.io:8443/uapi/doc/) API docs for a list of all their endpoints.

## Install

Install by cloning the repo and run `setup.py`.

```bash
$ python3 setup.py install
```

## Usage

To initialize do the following.

```python
from pyjamf import Jamf
jamf = Jamf('username', 'password', 'https://jamf.example.com:8443')
```

Here are some examples on what you can do with the generic built-in functions.
You can request a Pro API endpoint by adding the `uapi=True` param to your function calls.

```python
jamf.http_get(url, params=params)
jamf.http_post(url, data=data)
jamf.http_patch(pro_endpoint_url, data=data, uapi=True)
jamf.http_delete(url)
```

The library support wrappers for Apps, Buildings, Devices, and Profiles.

```python
# List of apps
jamf.apps.list()

# Get profile details by internal id
jamf.profiles.get(record_id)

# Update a device
jamf.profiles.update(record_id, data=data)

# Delete a building
jamf.buildings.delete(record_id)
```
