#!/usr/bin/env python3
import io
import os
import re

from setuptools import setup, find_packages


def get_version():
    with open('pybeacon/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of pybeacon")

        version = match.group(1)
        return version


here = os.path.abspath(os.path.dirname(__file__))
with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = '\n' + f.read()

setup(
    name='pybeacon',
    version=get_version(),
    description="Beacon MDM Client",
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Joshua Burkholder',
    author_email='joshua@compassfoundation.io',
    packages=find_packages(exclude=["tests"]),
    package_dir={'': '.'},
    license='AGPL',
    zip_safe=True,
    url='https://code.compassfoundation.io/cloudberry/pybeacon',
    include_package_data=True,
    install_requires=[
        'lcrequests',
    ],
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: Implementation :: CPython',
    ],
)
