from lcrequests.exceptions import (
    LCHTTPError,
    AuthenticationError,
    AuthorizationError,
    ClientError,
    ServerError,
)


class BeaconError(LCHTTPError):
    """A generic error while attempting to communicate with Beacon"""


class BeaconServerError(ServerError):
    """The Beacon Server encountered an error while processing the request"""


class BeaconAuthenticationError(AuthenticationError):
    """Invalid authentication credentials"""


class BeaconAuthorizationError(AuthorizationError):
    """Invalid permission levels"""


class BeaconClientError(ClientError):
    """An invalid request has been made"""


__all__ = [
    'BeaconError',
    'BeaconServerError',
    'BeaconAuthenticationError',
    'BeaconAuthorizationError',
    'BeaconClientError',
]
