import io
import os
from setuptools import setup, find_packages
import py_odoo

here = os.path.abspath(os.path.dirname(__file__))
with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = '\n' + f.read()

setup(
    name='py_odoo',
    version=py_odoo.__version__,
    description="Python wrapper for Odoo REST API",
    long_description=long_description,
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    packages=find_packages(exclude=["tests"]),
    package_dir={'': '.'},
    license='MIT',
    zip_safe=True,
    url='https://code.compassfoundation.io/odoo/pyodoo',
    include_package_data=True,
    install_requires=[
        'lcconfig',
        'lchttp',
        'lcrequests',
    ],
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
    ],
)
