# PyOdoo

Python wrapper for Odoo REST API

# Installation
Ensure python 3.6 or higher is installed on your machine; will vary by distro.

Clone this repo or download zipped file and unzip.
* `cd pyodoo`
* `sudo pip3 install -r requirements.txt`
* `sudo pip3 install .`


# Usage

```
from py_odoo.py_odoo import BaseOdoo


odoo = BaseOdoo('https://erp.example.com', 'username', 'password', 'database')

# Set the Odoo model environment
# (check model query param in Odoo URL to find string value of the desired model)
# https://erp.compassfoundation.io/web#id=17445&action=345&model=res.partner&menu_id=246
# &model=res.partner
odoo.load('res.partner')

# Browse records by ID
odoo.browse(55, fields=('name', 'phone'))

# Browse records by Canonical ID (where model has `cid` field)
odoo.scid("d6ade94e-c05e-6258-8f6d-fb7d060014cf", fields=('name', 'phone'))

# Search using Odoo API search syntax
odoo.search(([('is_company', '=', 'True')]), fields=('name', 'phone'))

# Create a new record
data = {
    'name': 'John Smith',
    'company_type': 'company',
    'country_id': 105,
    'phone': '9876543210',
}
odoo.create(data)

# Update an existing record
data = {
    'name': 'James Smith'
}
odoo.write(55, data)

# Delete a record
odoo.unlink(55)

# Remote procedure call 
odoo.rpc(55, 'name_search', method_args={'name': 'John Smith'})
```

# Odoo API Reference
https://odoo-new-api-guide-line.readthedocs.io/en/latest/index.html